/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.CA;
import io.dekorate.certmanager.config.CABuilder;
import io.dekorate.certmanager.config.CAFluent;
import io.dekorate.certmanager.config.CertificateConfig;
import io.dekorate.certmanager.config.CertificateKeystores;
import io.dekorate.certmanager.config.CertificateKeystoresBuilder;
import io.dekorate.certmanager.config.CertificateKeystoresFluent;
import io.dekorate.certmanager.config.CertificatePrivateKey;
import io.dekorate.certmanager.config.CertificatePrivateKeyBuilder;
import io.dekorate.certmanager.config.CertificatePrivateKeyFluent;
import io.dekorate.certmanager.config.IssuerRef;
import io.dekorate.certmanager.config.IssuerRefBuilder;
import io.dekorate.certmanager.config.IssuerRefFluent;
import io.dekorate.certmanager.config.SelfSigned;
import io.dekorate.certmanager.config.SelfSignedBuilder;
import io.dekorate.certmanager.config.SelfSignedFluent;
import io.dekorate.certmanager.config.Subject;
import io.dekorate.certmanager.config.SubjectBuilder;
import io.dekorate.certmanager.config.SubjectFluent;
import io.dekorate.certmanager.config.Vault;
import io.dekorate.certmanager.config.VaultBuilder;
import io.dekorate.certmanager.config.VaultFluent;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CertificateConfigFluent<A extends CertificateConfigFluent<A>>
extends ConfigurationFluent<A> {
    private String name;
    private String secretName;
    private IssuerRefBuilder issuerRef;
    private CABuilder ca;
    private VaultBuilder vault;
    private SelfSignedBuilder selfSigned;
    private SubjectBuilder subject;
    private String commonName;
    private String duration;
    private String renewBefore;
    private List<String> dnsNames = new ArrayList<String>();
    private List<String> ipAddresses = new ArrayList<String>();
    private List<String> uris = new ArrayList<String>();
    private List<String> emailAddresses = new ArrayList<String>();
    private CertificateKeystoresBuilder keystores;
    private Boolean isCA;
    private List<String> usages = new ArrayList<String>();
    private CertificatePrivateKeyBuilder privateKey;
    private Boolean encodeUsagesInRequest;
    private String volumeMountPath;

    public CertificateConfigFluent() {
    }

    public CertificateConfigFluent(CertificateConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CertificateConfig instance) {
        CertificateConfig certificateConfig = instance = instance != null ? instance : new CertificateConfig();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withName(instance.getName());
            this.withSecretName(instance.getSecretName());
            this.withIssuerRef(instance.getIssuerRef());
            this.withCa(instance.getCa());
            this.withVault(instance.getVault());
            this.withSelfSigned(instance.getSelfSigned());
            this.withSubject(instance.getSubject());
            this.withCommonName(instance.getCommonName());
            this.withDuration(instance.getDuration());
            this.withRenewBefore(instance.getRenewBefore());
            this.withDnsNames(instance.getDnsNames());
            this.withIpAddresses(instance.getIpAddresses());
            this.withUris(instance.getUris());
            this.withEmailAddresses(instance.getEmailAddresses());
            this.withKeystores(instance.getKeystores());
            this.withIsCA(instance.getIsCA());
            this.withUsages(instance.getUsages());
            this.withPrivateKey(instance.getPrivateKey());
            this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
            this.withVolumeMountPath(instance.getVolumeMountPath());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)((Object)this);
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    public IssuerRef buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    public A withIssuerRef(IssuerRef issuerRef) {
        this._visitables.remove((Object)"issuerRef");
        if (issuerRef != null) {
            this.issuerRef = new IssuerRefBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        }
        return (A)((Object)this);
    }

    public boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public A withNewIssuerRef(String name, String kind, String group) {
        return this.withIssuerRef(new IssuerRef(name, kind, group));
    }

    public IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNested(null);
    }

    public IssuerRefNested<A> withNewIssuerRefLike(IssuerRef item) {
        return new IssuerRefNested(item);
    }

    public IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(null));
    }

    public IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(new IssuerRefBuilder().build()));
    }

    public IssuerRefNested<A> editOrNewIssuerRefLike(IssuerRef item) {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(item));
    }

    public CA buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public A withCa(CA ca) {
        this._visitables.remove((Object)"ca");
        if (ca != null) {
            this.ca = new CABuilder(ca);
            this._visitables.get((Object)"ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get((Object)"ca").remove((Object)this.ca);
        }
        return (A)((Object)this);
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(String secretName, String[] crlDistributionPoints) {
        return this.withCa(new CA(secretName, crlDistributionPoints));
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public CaNested<A> withNewCaLike(CA item) {
        return new CaNested(item);
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new CABuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(CA item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public Vault buildVault() {
        return this.vault != null ? this.vault.build() : null;
    }

    public A withVault(Vault vault) {
        this._visitables.remove((Object)"vault");
        if (vault != null) {
            this.vault = new VaultBuilder(vault);
            this._visitables.get((Object)"vault").add(this.vault);
        } else {
            this.vault = null;
            this._visitables.get((Object)"vault").remove((Object)this.vault);
        }
        return (A)((Object)this);
    }

    public boolean hasVault() {
        return this.vault != null;
    }

    public VaultNested<A> withNewVault() {
        return new VaultNested(null);
    }

    public VaultNested<A> withNewVaultLike(Vault item) {
        return new VaultNested(item);
    }

    public VaultNested<A> editVault() {
        return this.withNewVaultLike(Optional.ofNullable(this.buildVault()).orElse(null));
    }

    public VaultNested<A> editOrNewVault() {
        return this.withNewVaultLike(Optional.ofNullable(this.buildVault()).orElse(new VaultBuilder().build()));
    }

    public VaultNested<A> editOrNewVaultLike(Vault item) {
        return this.withNewVaultLike(Optional.ofNullable(this.buildVault()).orElse(item));
    }

    public SelfSigned buildSelfSigned() {
        return this.selfSigned != null ? this.selfSigned.build() : null;
    }

    public A withSelfSigned(SelfSigned selfSigned) {
        this._visitables.remove((Object)"selfSigned");
        if (selfSigned != null) {
            this.selfSigned = new SelfSignedBuilder(selfSigned);
            this._visitables.get((Object)"selfSigned").add(this.selfSigned);
        } else {
            this.selfSigned = null;
            this._visitables.get((Object)"selfSigned").remove((Object)this.selfSigned);
        }
        return (A)((Object)this);
    }

    public boolean hasSelfSigned() {
        return this.selfSigned != null;
    }

    public A withNewSelfSigned(Boolean enabled, String[] crlDistributionPoints) {
        return this.withSelfSigned(new SelfSigned(enabled, crlDistributionPoints));
    }

    public SelfSignedNested<A> withNewSelfSigned() {
        return new SelfSignedNested(null);
    }

    public SelfSignedNested<A> withNewSelfSignedLike(SelfSigned item) {
        return new SelfSignedNested(item);
    }

    public SelfSignedNested<A> editSelfSigned() {
        return this.withNewSelfSignedLike(Optional.ofNullable(this.buildSelfSigned()).orElse(null));
    }

    public SelfSignedNested<A> editOrNewSelfSigned() {
        return this.withNewSelfSignedLike(Optional.ofNullable(this.buildSelfSigned()).orElse(new SelfSignedBuilder().build()));
    }

    public SelfSignedNested<A> editOrNewSelfSignedLike(SelfSigned item) {
        return this.withNewSelfSignedLike(Optional.ofNullable(this.buildSelfSigned()).orElse(item));
    }

    public Subject buildSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    public A withSubject(Subject subject) {
        this._visitables.remove((Object)"subject");
        if (subject != null) {
            this.subject = new SubjectBuilder(subject);
            this._visitables.get((Object)"subject").add(this.subject);
        } else {
            this.subject = null;
            this._visitables.get((Object)"subject").remove((Object)this.subject);
        }
        return (A)((Object)this);
    }

    public boolean hasSubject() {
        return this.subject != null;
    }

    public SubjectNested<A> withNewSubject() {
        return new SubjectNested(null);
    }

    public SubjectNested<A> withNewSubjectLike(Subject item) {
        return new SubjectNested(item);
    }

    public SubjectNested<A> editSubject() {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(null));
    }

    public SubjectNested<A> editOrNewSubject() {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(new SubjectBuilder().build()));
    }

    public SubjectNested<A> editOrNewSubjectLike(Subject item) {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(item));
    }

    public String getCommonName() {
        return this.commonName;
    }

    public A withCommonName(String commonName) {
        this.commonName = commonName;
        return (A)((Object)this);
    }

    public boolean hasCommonName() {
        return this.commonName != null;
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public String getRenewBefore() {
        return this.renewBefore;
    }

    public A withRenewBefore(String renewBefore) {
        this.renewBefore = renewBefore;
        return (A)((Object)this);
    }

    public boolean hasRenewBefore() {
        return this.renewBefore != null;
    }

    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
            this._visitables.remove((Object)"dnsNames");
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getDnsNames() {
        int size = this.dnsNames != null ? this.dnsNames.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.dnsNames) {
            result[index++] = item;
        }
        return result;
    }

    public A addToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDnsNames(String ... items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    public A withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses != null) {
            this.ipAddresses.clear();
            this._visitables.remove((Object)"ipAddresses");
        }
        if (ipAddresses != null) {
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getIpAddresses() {
        int size = this.ipAddresses != null ? this.ipAddresses.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.ipAddresses) {
            result[index++] = item;
        }
        return result;
    }

    public A addToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasIpAddresses() {
        return this.ipAddresses != null && !this.ipAddresses.isEmpty();
    }

    public A withUris(String ... uris) {
        if (this.uris != null) {
            this.uris.clear();
            this._visitables.remove((Object)"uris");
        }
        if (uris != null) {
            for (String item : uris) {
                this.addToUris(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getUris() {
        int size = this.uris != null ? this.uris.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.uris) {
            result[index++] = item;
        }
        return result;
    }

    public A addToUris(int index, String item) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.add(index, item);
        return (A)((Object)this);
    }

    public A setToUris(int index, String item) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.set(index, item);
        return (A)((Object)this);
    }

    public A addToUris(String ... items) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        for (String item : items) {
            this.uris.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUris(Collection<String> items) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        for (String item : items) {
            this.uris.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUris(String ... items) {
        if (this.uris == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.uris.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUris(Collection<String> items) {
        if (this.uris == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.uris.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasUris() {
        return this.uris != null && !this.uris.isEmpty();
    }

    public A withEmailAddresses(String ... emailAddresses) {
        if (this.emailAddresses != null) {
            this.emailAddresses.clear();
            this._visitables.remove((Object)"emailAddresses");
        }
        if (emailAddresses != null) {
            for (String item : emailAddresses) {
                this.addToEmailAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getEmailAddresses() {
        int size = this.emailAddresses != null ? this.emailAddresses.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.emailAddresses) {
            result[index++] = item;
        }
        return result;
    }

    public A addToEmailAddresses(int index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToEmailAddresses(int index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToEmailAddresses(String ... items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEmailAddresses(Collection<String> items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEmailAddresses(String ... items) {
        if (this.emailAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.emailAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEmailAddresses(Collection<String> items) {
        if (this.emailAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.emailAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasEmailAddresses() {
        return this.emailAddresses != null && !this.emailAddresses.isEmpty();
    }

    public CertificateKeystores buildKeystores() {
        return this.keystores != null ? this.keystores.build() : null;
    }

    public A withKeystores(CertificateKeystores keystores) {
        this._visitables.remove((Object)"keystores");
        if (keystores != null) {
            this.keystores = new CertificateKeystoresBuilder(keystores);
            this._visitables.get((Object)"keystores").add(this.keystores);
        } else {
            this.keystores = null;
            this._visitables.get((Object)"keystores").remove((Object)this.keystores);
        }
        return (A)((Object)this);
    }

    public boolean hasKeystores() {
        return this.keystores != null;
    }

    public KeystoresNested<A> withNewKeystores() {
        return new KeystoresNested(null);
    }

    public KeystoresNested<A> withNewKeystoresLike(CertificateKeystores item) {
        return new KeystoresNested(item);
    }

    public KeystoresNested<A> editKeystores() {
        return this.withNewKeystoresLike(Optional.ofNullable(this.buildKeystores()).orElse(null));
    }

    public KeystoresNested<A> editOrNewKeystores() {
        return this.withNewKeystoresLike(Optional.ofNullable(this.buildKeystores()).orElse(new CertificateKeystoresBuilder().build()));
    }

    public KeystoresNested<A> editOrNewKeystoresLike(CertificateKeystores item) {
        return this.withNewKeystoresLike(Optional.ofNullable(this.buildKeystores()).orElse(item));
    }

    public Boolean getIsCA() {
        return this.isCA;
    }

    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)((Object)this);
    }

    public boolean hasIsCA() {
        return this.isCA != null;
    }

    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
            this._visitables.remove((Object)"usages");
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getUsages() {
        int size = this.usages != null ? this.usages.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.usages) {
            result[index++] = item;
        }
        return result;
    }

    public A addToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)((Object)this);
    }

    public A setToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)((Object)this);
    }

    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUsages(String ... items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUsages(Collection<String> items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    public CertificatePrivateKey buildPrivateKey() {
        return this.privateKey != null ? this.privateKey.build() : null;
    }

    public A withPrivateKey(CertificatePrivateKey privateKey) {
        this._visitables.remove((Object)"privateKey");
        if (privateKey != null) {
            this.privateKey = new CertificatePrivateKeyBuilder(privateKey);
            this._visitables.get((Object)"privateKey").add(this.privateKey);
        } else {
            this.privateKey = null;
            this._visitables.get((Object)"privateKey").remove((Object)this.privateKey);
        }
        return (A)((Object)this);
    }

    public boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    public PrivateKeyNested<A> withNewPrivateKey() {
        return new PrivateKeyNested(null);
    }

    public PrivateKeyNested<A> withNewPrivateKeyLike(CertificatePrivateKey item) {
        return new PrivateKeyNested(item);
    }

    public PrivateKeyNested<A> editPrivateKey() {
        return this.withNewPrivateKeyLike(Optional.ofNullable(this.buildPrivateKey()).orElse(null));
    }

    public PrivateKeyNested<A> editOrNewPrivateKey() {
        return this.withNewPrivateKeyLike(Optional.ofNullable(this.buildPrivateKey()).orElse(new CertificatePrivateKeyBuilder().build()));
    }

    public PrivateKeyNested<A> editOrNewPrivateKeyLike(CertificatePrivateKey item) {
        return this.withNewPrivateKeyLike(Optional.ofNullable(this.buildPrivateKey()).orElse(item));
    }

    public Boolean getEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest;
    }

    public A withEncodeUsagesInRequest(Boolean encodeUsagesInRequest) {
        this.encodeUsagesInRequest = encodeUsagesInRequest;
        return (A)((Object)this);
    }

    public boolean hasEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest != null;
    }

    public String getVolumeMountPath() {
        return this.volumeMountPath;
    }

    public A withVolumeMountPath(String volumeMountPath) {
        this.volumeMountPath = volumeMountPath;
        return (A)((Object)this);
    }

    public boolean hasVolumeMountPath() {
        return this.volumeMountPath != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateConfigFluent that = (CertificateConfigFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        if (!Objects.equals((Object)this.issuerRef, (Object)that.issuerRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.ca, (Object)that.ca)) {
            return false;
        }
        if (!Objects.equals((Object)this.vault, (Object)that.vault)) {
            return false;
        }
        if (!Objects.equals((Object)this.selfSigned, (Object)that.selfSigned)) {
            return false;
        }
        if (!Objects.equals((Object)this.subject, (Object)that.subject)) {
            return false;
        }
        if (!Objects.equals(this.commonName, that.commonName)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.renewBefore, that.renewBefore)) {
            return false;
        }
        if (!Objects.equals(this.dnsNames, that.dnsNames)) {
            return false;
        }
        if (!Objects.equals(this.ipAddresses, that.ipAddresses)) {
            return false;
        }
        if (!Objects.equals(this.uris, that.uris)) {
            return false;
        }
        if (!Objects.equals(this.emailAddresses, that.emailAddresses)) {
            return false;
        }
        if (!Objects.equals((Object)this.keystores, (Object)that.keystores)) {
            return false;
        }
        if (!Objects.equals(this.isCA, that.isCA)) {
            return false;
        }
        if (!Objects.equals(this.usages, that.usages)) {
            return false;
        }
        if (!Objects.equals((Object)this.privateKey, (Object)that.privateKey)) {
            return false;
        }
        if (!Objects.equals(this.encodeUsagesInRequest, that.encodeUsagesInRequest)) {
            return false;
        }
        return Objects.equals(this.volumeMountPath, that.volumeMountPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.secretName, this.issuerRef, this.ca, this.vault, this.selfSigned, this.subject, this.commonName, this.duration, this.renewBefore, this.dnsNames, this.ipAddresses, this.uris, this.emailAddresses, this.keystores, this.isCA, this.usages, this.privateKey, this.encodeUsagesInRequest, this.volumeMountPath, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append((Object)((Object)this.issuerRef) + ",");
        }
        if (this.ca != null) {
            sb.append("ca:");
            sb.append((Object)((Object)this.ca) + ",");
        }
        if (this.vault != null) {
            sb.append("vault:");
            sb.append((Object)((Object)this.vault) + ",");
        }
        if (this.selfSigned != null) {
            sb.append("selfSigned:");
            sb.append((Object)((Object)this.selfSigned) + ",");
        }
        if (this.subject != null) {
            sb.append("subject:");
            sb.append((Object)((Object)this.subject) + ",");
        }
        if (this.commonName != null) {
            sb.append("commonName:");
            sb.append(this.commonName + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.renewBefore != null) {
            sb.append("renewBefore:");
            sb.append(this.renewBefore + ",");
        }
        if (this.dnsNames != null && !this.dnsNames.isEmpty()) {
            sb.append("dnsNames:");
            sb.append(this.dnsNames + ",");
        }
        if (this.ipAddresses != null && !this.ipAddresses.isEmpty()) {
            sb.append("ipAddresses:");
            sb.append(this.ipAddresses + ",");
        }
        if (this.uris != null && !this.uris.isEmpty()) {
            sb.append("uris:");
            sb.append(this.uris + ",");
        }
        if (this.emailAddresses != null && !this.emailAddresses.isEmpty()) {
            sb.append("emailAddresses:");
            sb.append(this.emailAddresses + ",");
        }
        if (this.keystores != null) {
            sb.append("keystores:");
            sb.append((Object)((Object)this.keystores) + ",");
        }
        if (this.isCA != null) {
            sb.append("isCA:");
            sb.append(this.isCA + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages + ",");
        }
        if (this.privateKey != null) {
            sb.append("privateKey:");
            sb.append((Object)((Object)this.privateKey) + ",");
        }
        if (this.encodeUsagesInRequest != null) {
            sb.append("encodeUsagesInRequest:");
            sb.append(this.encodeUsagesInRequest + ",");
        }
        if (this.volumeMountPath != null) {
            sb.append("volumeMountPath:");
            sb.append(this.volumeMountPath);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIsCA() {
        return this.withIsCA(true);
    }

    public A withEncodeUsagesInRequest() {
        return this.withEncodeUsagesInRequest(true);
    }

    public class PrivateKeyNested<N>
    extends CertificatePrivateKeyFluent<PrivateKeyNested<N>>
    implements Nested<N> {
        CertificatePrivateKeyBuilder builder;

        PrivateKeyNested(CertificatePrivateKey item) {
            this.builder = new CertificatePrivateKeyBuilder(this, item);
        }

        public N and() {
            return (N)CertificateConfigFluent.this.withPrivateKey(this.builder.build());
        }

        public N endPrivateKey() {
            return this.and();
        }
    }

    public class KeystoresNested<N>
    extends CertificateKeystoresFluent<KeystoresNested<N>>
    implements Nested<N> {
        CertificateKeystoresBuilder builder;

        KeystoresNested(CertificateKeystores item) {
            this.builder = new CertificateKeystoresBuilder(this, item);
        }

        public N and() {
            return (N)CertificateConfigFluent.this.withKeystores(this.builder.build());
        }

        public N endKeystores() {
            return this.and();
        }
    }

    public class SubjectNested<N>
    extends SubjectFluent<SubjectNested<N>>
    implements Nested<N> {
        SubjectBuilder builder;

        SubjectNested(Subject item) {
            this.builder = new SubjectBuilder(this, item);
        }

        public N and() {
            return (N)CertificateConfigFluent.this.withSubject(this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }

    public class SelfSignedNested<N>
    extends SelfSignedFluent<SelfSignedNested<N>>
    implements Nested<N> {
        SelfSignedBuilder builder;

        SelfSignedNested(SelfSigned item) {
            this.builder = new SelfSignedBuilder(this, item);
        }

        public N and() {
            return (N)CertificateConfigFluent.this.withSelfSigned(this.builder.build());
        }

        public N endSelfSigned() {
            return this.and();
        }
    }

    public class VaultNested<N>
    extends VaultFluent<VaultNested<N>>
    implements Nested<N> {
        VaultBuilder builder;

        VaultNested(Vault item) {
            this.builder = new VaultBuilder(this, item);
        }

        public N and() {
            return (N)CertificateConfigFluent.this.withVault(this.builder.build());
        }

        public N endVault() {
            return this.and();
        }
    }

    public class CaNested<N>
    extends CAFluent<CaNested<N>>
    implements Nested<N> {
        CABuilder builder;

        CaNested(CA item) {
            this.builder = new CABuilder(this, item);
        }

        public N and() {
            return (N)CertificateConfigFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }

    public class IssuerRefNested<N>
    extends IssuerRefFluent<IssuerRefNested<N>>
    implements Nested<N> {
        IssuerRefBuilder builder;

        IssuerRefNested(IssuerRef item) {
            this.builder = new IssuerRefBuilder(this, item);
        }

        public N and() {
            return (N)CertificateConfigFluent.this.withIssuerRef(this.builder.build());
        }

        public N endIssuerRef() {
            return this.and();
        }
    }
}

