/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.SelfSigned;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SelfSignedFluent<A extends SelfSignedFluent<A>>
extends BaseFluent<A> {
    private Boolean enabled;
    private List<String> crlDistributionPoints = new ArrayList<String>();

    public SelfSignedFluent() {
    }

    public SelfSignedFluent(SelfSigned instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SelfSigned instance) {
        SelfSigned selfSigned = instance = instance != null ? instance : new SelfSigned();
        if (instance != null) {
            this.withEnabled(instance.getEnabled());
            this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A withCrlDistributionPoints(String ... crlDistributionPoints) {
        if (this.crlDistributionPoints != null) {
            this.crlDistributionPoints.clear();
            this._visitables.remove((Object)"crlDistributionPoints");
        }
        if (crlDistributionPoints != null) {
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getCrlDistributionPoints() {
        int size = this.crlDistributionPoints != null ? this.crlDistributionPoints.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.crlDistributionPoints) {
            result[index++] = item;
        }
        return result;
    }

    public A addToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(index, item);
        return (A)((Object)this);
    }

    public A setToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.set(index, item);
        return (A)((Object)this);
    }

    public A addToCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasCrlDistributionPoints() {
        return this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelfSignedFluent that = (SelfSignedFluent)((Object)o);
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        return Objects.equals(this.crlDistributionPoints, that.crlDistributionPoints);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.crlDistributionPoints, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty()) {
            sb.append("crlDistributionPoints:");
            sb.append(this.crlDistributionPoints);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }
}

