/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.Subject;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SubjectFluent<A extends SubjectFluent<A>>
extends BaseFluent<A> {
    private List<String> organizations = new ArrayList<String>();
    private List<String> countries = new ArrayList<String>();
    private List<String> organizationalUnits = new ArrayList<String>();
    private List<String> localities = new ArrayList<String>();
    private List<String> provinces = new ArrayList<String>();
    private List<String> streetAddresses = new ArrayList<String>();
    private List<String> postalCodes = new ArrayList<String>();
    private String serialNumber;

    public SubjectFluent() {
    }

    public SubjectFluent(Subject instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Subject instance) {
        Subject subject = instance = instance != null ? instance : new Subject();
        if (instance != null) {
            this.withOrganizations(instance.getOrganizations());
            this.withCountries(instance.getCountries());
            this.withOrganizationalUnits(instance.getOrganizationalUnits());
            this.withLocalities(instance.getLocalities());
            this.withProvinces(instance.getProvinces());
            this.withStreetAddresses(instance.getStreetAddresses());
            this.withPostalCodes(instance.getPostalCodes());
            this.withSerialNumber(instance.getSerialNumber());
        }
    }

    public A withOrganizations(String ... organizations) {
        if (this.organizations != null) {
            this.organizations.clear();
            this._visitables.remove((Object)"organizations");
        }
        if (organizations != null) {
            for (String item : organizations) {
                this.addToOrganizations(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getOrganizations() {
        int size = this.organizations != null ? this.organizations.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.organizations) {
            result[index++] = item;
        }
        return result;
    }

    public A addToOrganizations(int index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.add(index, item);
        return (A)((Object)this);
    }

    public A setToOrganizations(int index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.set(index, item);
        return (A)((Object)this);
    }

    public A addToOrganizations(String ... items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOrganizations(Collection<String> items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOrganizations(String ... items) {
        if (this.organizations == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organizations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOrganizations(Collection<String> items) {
        if (this.organizations == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organizations.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasOrganizations() {
        return this.organizations != null && !this.organizations.isEmpty();
    }

    public A withCountries(String ... countries) {
        if (this.countries != null) {
            this.countries.clear();
            this._visitables.remove((Object)"countries");
        }
        if (countries != null) {
            for (String item : countries) {
                this.addToCountries(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getCountries() {
        int size = this.countries != null ? this.countries.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.countries) {
            result[index++] = item;
        }
        return result;
    }

    public A addToCountries(int index, String item) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.add(index, item);
        return (A)((Object)this);
    }

    public A setToCountries(int index, String item) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.set(index, item);
        return (A)((Object)this);
    }

    public A addToCountries(String ... items) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        for (String item : items) {
            this.countries.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCountries(Collection<String> items) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        for (String item : items) {
            this.countries.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCountries(String ... items) {
        if (this.countries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.countries.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCountries(Collection<String> items) {
        if (this.countries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.countries.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasCountries() {
        return this.countries != null && !this.countries.isEmpty();
    }

    public A withOrganizationalUnits(String ... organizationalUnits) {
        if (this.organizationalUnits != null) {
            this.organizationalUnits.clear();
            this._visitables.remove((Object)"organizationalUnits");
        }
        if (organizationalUnits != null) {
            for (String item : organizationalUnits) {
                this.addToOrganizationalUnits(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getOrganizationalUnits() {
        int size = this.organizationalUnits != null ? this.organizationalUnits.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.organizationalUnits) {
            result[index++] = item;
        }
        return result;
    }

    public A addToOrganizationalUnits(int index, String item) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        this.organizationalUnits.add(index, item);
        return (A)((Object)this);
    }

    public A setToOrganizationalUnits(int index, String item) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        this.organizationalUnits.set(index, item);
        return (A)((Object)this);
    }

    public A addToOrganizationalUnits(String ... items) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizationalUnits.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOrganizationalUnits(Collection<String> items) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizationalUnits.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOrganizationalUnits(String ... items) {
        if (this.organizationalUnits == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organizationalUnits.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOrganizationalUnits(Collection<String> items) {
        if (this.organizationalUnits == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.organizationalUnits.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasOrganizationalUnits() {
        return this.organizationalUnits != null && !this.organizationalUnits.isEmpty();
    }

    public A withLocalities(String ... localities) {
        if (this.localities != null) {
            this.localities.clear();
            this._visitables.remove((Object)"localities");
        }
        if (localities != null) {
            for (String item : localities) {
                this.addToLocalities(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getLocalities() {
        int size = this.localities != null ? this.localities.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.localities) {
            result[index++] = item;
        }
        return result;
    }

    public A addToLocalities(int index, String item) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        this.localities.add(index, item);
        return (A)((Object)this);
    }

    public A setToLocalities(int index, String item) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        this.localities.set(index, item);
        return (A)((Object)this);
    }

    public A addToLocalities(String ... items) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        for (String item : items) {
            this.localities.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToLocalities(Collection<String> items) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        for (String item : items) {
            this.localities.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromLocalities(String ... items) {
        if (this.localities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.localities.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLocalities(Collection<String> items) {
        if (this.localities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.localities.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasLocalities() {
        return this.localities != null && !this.localities.isEmpty();
    }

    public A withProvinces(String ... provinces) {
        if (this.provinces != null) {
            this.provinces.clear();
            this._visitables.remove((Object)"provinces");
        }
        if (provinces != null) {
            for (String item : provinces) {
                this.addToProvinces(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getProvinces() {
        int size = this.provinces != null ? this.provinces.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.provinces) {
            result[index++] = item;
        }
        return result;
    }

    public A addToProvinces(int index, String item) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        this.provinces.add(index, item);
        return (A)((Object)this);
    }

    public A setToProvinces(int index, String item) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        this.provinces.set(index, item);
        return (A)((Object)this);
    }

    public A addToProvinces(String ... items) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        for (String item : items) {
            this.provinces.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToProvinces(Collection<String> items) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        for (String item : items) {
            this.provinces.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromProvinces(String ... items) {
        if (this.provinces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.provinces.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProvinces(Collection<String> items) {
        if (this.provinces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.provinces.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasProvinces() {
        return this.provinces != null && !this.provinces.isEmpty();
    }

    public A withStreetAddresses(String ... streetAddresses) {
        if (this.streetAddresses != null) {
            this.streetAddresses.clear();
            this._visitables.remove((Object)"streetAddresses");
        }
        if (streetAddresses != null) {
            for (String item : streetAddresses) {
                this.addToStreetAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getStreetAddresses() {
        int size = this.streetAddresses != null ? this.streetAddresses.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.streetAddresses) {
            result[index++] = item;
        }
        return result;
    }

    public A addToStreetAddresses(int index, String item) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        this.streetAddresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToStreetAddresses(int index, String item) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        this.streetAddresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToStreetAddresses(String ... items) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.streetAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToStreetAddresses(Collection<String> items) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.streetAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromStreetAddresses(String ... items) {
        if (this.streetAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.streetAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromStreetAddresses(Collection<String> items) {
        if (this.streetAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.streetAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasStreetAddresses() {
        return this.streetAddresses != null && !this.streetAddresses.isEmpty();
    }

    public A withPostalCodes(String ... postalCodes) {
        if (this.postalCodes != null) {
            this.postalCodes.clear();
            this._visitables.remove((Object)"postalCodes");
        }
        if (postalCodes != null) {
            for (String item : postalCodes) {
                this.addToPostalCodes(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getPostalCodes() {
        int size = this.postalCodes != null ? this.postalCodes.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.postalCodes) {
            result[index++] = item;
        }
        return result;
    }

    public A addToPostalCodes(int index, String item) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        this.postalCodes.add(index, item);
        return (A)((Object)this);
    }

    public A setToPostalCodes(int index, String item) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        this.postalCodes.set(index, item);
        return (A)((Object)this);
    }

    public A addToPostalCodes(String ... items) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.postalCodes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPostalCodes(Collection<String> items) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.postalCodes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPostalCodes(String ... items) {
        if (this.postalCodes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.postalCodes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPostalCodes(Collection<String> items) {
        if (this.postalCodes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.postalCodes.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasPostalCodes() {
        return this.postalCodes != null && !this.postalCodes.isEmpty();
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public A withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return (A)((Object)this);
    }

    public boolean hasSerialNumber() {
        return this.serialNumber != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubjectFluent that = (SubjectFluent)((Object)o);
        if (!Objects.equals(this.organizations, that.organizations)) {
            return false;
        }
        if (!Objects.equals(this.countries, that.countries)) {
            return false;
        }
        if (!Objects.equals(this.organizationalUnits, that.organizationalUnits)) {
            return false;
        }
        if (!Objects.equals(this.localities, that.localities)) {
            return false;
        }
        if (!Objects.equals(this.provinces, that.provinces)) {
            return false;
        }
        if (!Objects.equals(this.streetAddresses, that.streetAddresses)) {
            return false;
        }
        if (!Objects.equals(this.postalCodes, that.postalCodes)) {
            return false;
        }
        return Objects.equals(this.serialNumber, that.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.organizations, this.countries, this.organizationalUnits, this.localities, this.provinces, this.streetAddresses, this.postalCodes, this.serialNumber, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.organizations != null && !this.organizations.isEmpty()) {
            sb.append("organizations:");
            sb.append(this.organizations + ",");
        }
        if (this.countries != null && !this.countries.isEmpty()) {
            sb.append("countries:");
            sb.append(this.countries + ",");
        }
        if (this.organizationalUnits != null && !this.organizationalUnits.isEmpty()) {
            sb.append("organizationalUnits:");
            sb.append(this.organizationalUnits + ",");
        }
        if (this.localities != null && !this.localities.isEmpty()) {
            sb.append("localities:");
            sb.append(this.localities + ",");
        }
        if (this.provinces != null && !this.provinces.isEmpty()) {
            sb.append("provinces:");
            sb.append(this.provinces + ",");
        }
        if (this.streetAddresses != null && !this.streetAddresses.isEmpty()) {
            sb.append("streetAddresses:");
            sb.append(this.streetAddresses + ",");
        }
        if (this.postalCodes != null && !this.postalCodes.isEmpty()) {
            sb.append("postalCodes:");
            sb.append(this.postalCodes + ",");
        }
        if (this.serialNumber != null) {
            sb.append("serialNumber:");
            sb.append(this.serialNumber);
        }
        sb.append("}");
        return sb.toString();
    }
}

