/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.VaultAppRole;
import io.dekorate.certmanager.config.VaultBuilder;
import io.dekorate.certmanager.config.VaultKubernetesAuth;
import java.util.Objects;

public class Vault {
    private String server;
    private String path;
    private LocalObjectReference authTokenSecretRef;
    private VaultAppRole authAppRole;
    private VaultKubernetesAuth authKubernetes;
    private String namespace;
    private String caBundle;

    public Vault() {
    }

    public Vault(String server, String path, LocalObjectReference authTokenSecretRef, VaultAppRole authAppRole, VaultKubernetesAuth authKubernetes, String namespace, String caBundle) {
        this.server = server;
        this.path = path;
        this.authTokenSecretRef = authTokenSecretRef;
        this.authAppRole = authAppRole;
        this.authKubernetes = authKubernetes;
        this.namespace = namespace;
        this.caBundle = caBundle;
    }

    public String getServer() {
        return this.server;
    }

    public String getPath() {
        return this.path;
    }

    public LocalObjectReference getAuthTokenSecretRef() {
        return this.authTokenSecretRef;
    }

    public VaultAppRole getAuthAppRole() {
        return this.authAppRole;
    }

    public VaultKubernetesAuth getAuthKubernetes() {
        return this.authKubernetes;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getCaBundle() {
        return this.caBundle;
    }

    public static VaultBuilder newBuilder() {
        return new VaultBuilder();
    }

    public static VaultBuilder newBuilderFromDefaults() {
        return (VaultBuilder)((Object)((VaultBuilder)((Object)new VaultBuilder().withAuthAppRole(new VaultAppRole()))).withAuthKubernetes(new VaultKubernetesAuth()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Vault that = (Vault)o;
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.authTokenSecretRef, that.authTokenSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.authAppRole, that.authAppRole)) {
            return false;
        }
        if (!Objects.equals(this.authKubernetes, that.authKubernetes)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        return Objects.equals(this.caBundle, that.caBundle);
    }

    public int hashCode() {
        return Objects.hash(this.server, this.path, this.authTokenSecretRef, this.authAppRole, this.authKubernetes, this.namespace, this.caBundle, super.hashCode());
    }
}

