/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.LocalObjectReferenceBuilder;
import io.dekorate.certmanager.config.LocalObjectReferenceFluent;
import io.dekorate.certmanager.config.Vault;
import io.dekorate.certmanager.config.VaultAppRole;
import io.dekorate.certmanager.config.VaultAppRoleBuilder;
import io.dekorate.certmanager.config.VaultAppRoleFluent;
import io.dekorate.certmanager.config.VaultKubernetesAuth;
import io.dekorate.certmanager.config.VaultKubernetesAuthBuilder;
import io.dekorate.certmanager.config.VaultKubernetesAuthFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class VaultFluent<A extends VaultFluent<A>>
extends BaseFluent<A> {
    private String server;
    private String path;
    private LocalObjectReferenceBuilder authTokenSecretRef;
    private VaultAppRoleBuilder authAppRole;
    private VaultKubernetesAuthBuilder authKubernetes;
    private String namespace;
    private String caBundle;

    public VaultFluent() {
    }

    public VaultFluent(Vault instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Vault instance) {
        Vault vault = instance = instance != null ? instance : new Vault();
        if (instance != null) {
            this.withServer(instance.getServer());
            this.withPath(instance.getPath());
            this.withAuthTokenSecretRef(instance.getAuthTokenSecretRef());
            this.withAuthAppRole(instance.getAuthAppRole());
            this.withAuthKubernetes(instance.getAuthKubernetes());
            this.withNamespace(instance.getNamespace());
            this.withCaBundle(instance.getCaBundle());
        }
    }

    public String getServer() {
        return this.server;
    }

    public A withServer(String server) {
        this.server = server;
        return (A)((Object)this);
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public LocalObjectReference buildAuthTokenSecretRef() {
        return this.authTokenSecretRef != null ? this.authTokenSecretRef.build() : null;
    }

    public A withAuthTokenSecretRef(LocalObjectReference authTokenSecretRef) {
        this._visitables.remove((Object)"authTokenSecretRef");
        if (authTokenSecretRef != null) {
            this.authTokenSecretRef = new LocalObjectReferenceBuilder(authTokenSecretRef);
            this._visitables.get((Object)"authTokenSecretRef").add(this.authTokenSecretRef);
        } else {
            this.authTokenSecretRef = null;
            this._visitables.get((Object)"authTokenSecretRef").remove((Object)this.authTokenSecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthTokenSecretRef() {
        return this.authTokenSecretRef != null;
    }

    public A withNewAuthTokenSecretRef(String name, String key) {
        return this.withAuthTokenSecretRef(new LocalObjectReference(name, key));
    }

    public AuthTokenSecretRefNested<A> withNewAuthTokenSecretRef() {
        return new AuthTokenSecretRefNested(null);
    }

    public AuthTokenSecretRefNested<A> withNewAuthTokenSecretRefLike(LocalObjectReference item) {
        return new AuthTokenSecretRefNested(item);
    }

    public AuthTokenSecretRefNested<A> editAuthTokenSecretRef() {
        return this.withNewAuthTokenSecretRefLike(Optional.ofNullable(this.buildAuthTokenSecretRef()).orElse(null));
    }

    public AuthTokenSecretRefNested<A> editOrNewAuthTokenSecretRef() {
        return this.withNewAuthTokenSecretRefLike(Optional.ofNullable(this.buildAuthTokenSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public AuthTokenSecretRefNested<A> editOrNewAuthTokenSecretRefLike(LocalObjectReference item) {
        return this.withNewAuthTokenSecretRefLike(Optional.ofNullable(this.buildAuthTokenSecretRef()).orElse(item));
    }

    public VaultAppRole buildAuthAppRole() {
        return this.authAppRole != null ? this.authAppRole.build() : null;
    }

    public A withAuthAppRole(VaultAppRole authAppRole) {
        this._visitables.remove((Object)"authAppRole");
        if (authAppRole != null) {
            this.authAppRole = new VaultAppRoleBuilder(authAppRole);
            this._visitables.get((Object)"authAppRole").add(this.authAppRole);
        } else {
            this.authAppRole = null;
            this._visitables.get((Object)"authAppRole").remove((Object)this.authAppRole);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthAppRole() {
        return this.authAppRole != null;
    }

    public AuthAppRoleNested<A> withNewAuthAppRole() {
        return new AuthAppRoleNested(null);
    }

    public AuthAppRoleNested<A> withNewAuthAppRoleLike(VaultAppRole item) {
        return new AuthAppRoleNested(item);
    }

    public AuthAppRoleNested<A> editAuthAppRole() {
        return this.withNewAuthAppRoleLike(Optional.ofNullable(this.buildAuthAppRole()).orElse(null));
    }

    public AuthAppRoleNested<A> editOrNewAuthAppRole() {
        return this.withNewAuthAppRoleLike(Optional.ofNullable(this.buildAuthAppRole()).orElse(new VaultAppRoleBuilder().build()));
    }

    public AuthAppRoleNested<A> editOrNewAuthAppRoleLike(VaultAppRole item) {
        return this.withNewAuthAppRoleLike(Optional.ofNullable(this.buildAuthAppRole()).orElse(item));
    }

    public VaultKubernetesAuth buildAuthKubernetes() {
        return this.authKubernetes != null ? this.authKubernetes.build() : null;
    }

    public A withAuthKubernetes(VaultKubernetesAuth authKubernetes) {
        this._visitables.remove((Object)"authKubernetes");
        if (authKubernetes != null) {
            this.authKubernetes = new VaultKubernetesAuthBuilder(authKubernetes);
            this._visitables.get((Object)"authKubernetes").add(this.authKubernetes);
        } else {
            this.authKubernetes = null;
            this._visitables.get((Object)"authKubernetes").remove((Object)this.authKubernetes);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthKubernetes() {
        return this.authKubernetes != null;
    }

    public AuthKubernetesNested<A> withNewAuthKubernetes() {
        return new AuthKubernetesNested(null);
    }

    public AuthKubernetesNested<A> withNewAuthKubernetesLike(VaultKubernetesAuth item) {
        return new AuthKubernetesNested(item);
    }

    public AuthKubernetesNested<A> editAuthKubernetes() {
        return this.withNewAuthKubernetesLike(Optional.ofNullable(this.buildAuthKubernetes()).orElse(null));
    }

    public AuthKubernetesNested<A> editOrNewAuthKubernetes() {
        return this.withNewAuthKubernetesLike(Optional.ofNullable(this.buildAuthKubernetes()).orElse(new VaultKubernetesAuthBuilder().build()));
    }

    public AuthKubernetesNested<A> editOrNewAuthKubernetesLike(VaultKubernetesAuth item) {
        return this.withNewAuthKubernetesLike(Optional.ofNullable(this.buildAuthKubernetes()).orElse(item));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getCaBundle() {
        return this.caBundle;
    }

    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)((Object)this);
    }

    public boolean hasCaBundle() {
        return this.caBundle != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VaultFluent that = (VaultFluent)((Object)o);
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals((Object)this.authTokenSecretRef, (Object)that.authTokenSecretRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.authAppRole, (Object)that.authAppRole)) {
            return false;
        }
        if (!Objects.equals((Object)this.authKubernetes, (Object)that.authKubernetes)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        return Objects.equals(this.caBundle, that.caBundle);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.server, this.path, this.authTokenSecretRef, this.authAppRole, this.authKubernetes, this.namespace, this.caBundle, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.authTokenSecretRef != null) {
            sb.append("authTokenSecretRef:");
            sb.append((Object)((Object)this.authTokenSecretRef) + ",");
        }
        if (this.authAppRole != null) {
            sb.append("authAppRole:");
            sb.append((Object)((Object)this.authAppRole) + ",");
        }
        if (this.authKubernetes != null) {
            sb.append("authKubernetes:");
            sb.append((Object)((Object)this.authKubernetes) + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.caBundle != null) {
            sb.append("caBundle:");
            sb.append(this.caBundle);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AuthKubernetesNested<N>
    extends VaultKubernetesAuthFluent<AuthKubernetesNested<N>>
    implements Nested<N> {
        VaultKubernetesAuthBuilder builder;

        AuthKubernetesNested(VaultKubernetesAuth item) {
            this.builder = new VaultKubernetesAuthBuilder(this, item);
        }

        public N and() {
            return (N)VaultFluent.this.withAuthKubernetes(this.builder.build());
        }

        public N endAuthKubernetes() {
            return this.and();
        }
    }

    public class AuthAppRoleNested<N>
    extends VaultAppRoleFluent<AuthAppRoleNested<N>>
    implements Nested<N> {
        VaultAppRoleBuilder builder;

        AuthAppRoleNested(VaultAppRole item) {
            this.builder = new VaultAppRoleBuilder(this, item);
        }

        public N and() {
            return (N)VaultFluent.this.withAuthAppRole(this.builder.build());
        }

        public N endAuthAppRole() {
            return this.and();
        }
    }

    public class AuthTokenSecretRefNested<N>
    extends LocalObjectReferenceFluent<AuthTokenSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        AuthTokenSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)VaultFluent.this.withAuthTokenSecretRef(this.builder.build());
        }

        public N endAuthTokenSecretRef() {
            return this.and();
        }
    }
}

