/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.CA;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CAFluent<A extends CAFluent<A>>
extends BaseFluent<A> {
    private String secretName;
    private List<String> crlDistributionPoints = new ArrayList<String>();

    public CAFluent() {
    }

    public CAFluent(CA instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CA instance) {
        CA cA = instance = instance != null ? instance : new CA();
        if (instance != null) {
            this.withSecretName(instance.getSecretName());
            this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        }
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)((Object)this);
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    public A withCrlDistributionPoints(String ... crlDistributionPoints) {
        if (this.crlDistributionPoints != null) {
            this.crlDistributionPoints.clear();
            this._visitables.remove((Object)"crlDistributionPoints");
        }
        if (crlDistributionPoints != null) {
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getCrlDistributionPoints() {
        int size = this.crlDistributionPoints != null ? this.crlDistributionPoints.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.crlDistributionPoints) {
            result[index++] = item;
        }
        return result;
    }

    public A addToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(index, item);
        return (A)((Object)this);
    }

    public A setToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.set(index, item);
        return (A)((Object)this);
    }

    public A addToCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasCrlDistributionPoints() {
        return this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CAFluent that = (CAFluent)((Object)o);
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        return Objects.equals(this.crlDistributionPoints, that.crlDistributionPoints);
    }

    public int hashCode() {
        return Objects.hash(this.secretName, this.crlDistributionPoints, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty()) {
            sb.append("crlDistributionPoints:");
            sb.append(this.crlDistributionPoints);
        }
        sb.append("}");
        return sb.toString();
    }
}

