/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.CertificateKeystore;
import io.dekorate.certmanager.config.CertificateKeystoreBuilder;
import io.dekorate.certmanager.config.CertificateKeystoreFluent;
import io.dekorate.certmanager.config.CertificateKeystores;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class CertificateKeystoresFluent<A extends CertificateKeystoresFluent<A>>
extends BaseFluent<A> {
    private CertificateKeystoreBuilder jks;
    private CertificateKeystoreBuilder pkcs12;

    public CertificateKeystoresFluent() {
    }

    public CertificateKeystoresFluent(CertificateKeystores instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CertificateKeystores instance) {
        CertificateKeystores certificateKeystores = instance = instance != null ? instance : new CertificateKeystores();
        if (instance != null) {
            this.withJks(instance.getJks());
            this.withPkcs12(instance.getPkcs12());
        }
    }

    public CertificateKeystore buildJks() {
        return this.jks != null ? this.jks.build() : null;
    }

    public A withJks(CertificateKeystore jks) {
        this._visitables.remove((Object)"jks");
        if (jks != null) {
            this.jks = new CertificateKeystoreBuilder(jks);
            this._visitables.get((Object)"jks").add(this.jks);
        } else {
            this.jks = null;
            this._visitables.get((Object)"jks").remove((Object)this.jks);
        }
        return (A)((Object)this);
    }

    public boolean hasJks() {
        return this.jks != null;
    }

    public JksNested<A> withNewJks() {
        return new JksNested(null);
    }

    public JksNested<A> withNewJksLike(CertificateKeystore item) {
        return new JksNested(item);
    }

    public JksNested<A> editJks() {
        return this.withNewJksLike(Optional.ofNullable(this.buildJks()).orElse(null));
    }

    public JksNested<A> editOrNewJks() {
        return this.withNewJksLike(Optional.ofNullable(this.buildJks()).orElse(new CertificateKeystoreBuilder().build()));
    }

    public JksNested<A> editOrNewJksLike(CertificateKeystore item) {
        return this.withNewJksLike(Optional.ofNullable(this.buildJks()).orElse(item));
    }

    public CertificateKeystore buildPkcs12() {
        return this.pkcs12 != null ? this.pkcs12.build() : null;
    }

    public A withPkcs12(CertificateKeystore pkcs12) {
        this._visitables.remove((Object)"pkcs12");
        if (pkcs12 != null) {
            this.pkcs12 = new CertificateKeystoreBuilder(pkcs12);
            this._visitables.get((Object)"pkcs12").add(this.pkcs12);
        } else {
            this.pkcs12 = null;
            this._visitables.get((Object)"pkcs12").remove((Object)this.pkcs12);
        }
        return (A)((Object)this);
    }

    public boolean hasPkcs12() {
        return this.pkcs12 != null;
    }

    public Pkcs12Nested<A> withNewPkcs12() {
        return new Pkcs12Nested(null);
    }

    public Pkcs12Nested<A> withNewPkcs12Like(CertificateKeystore item) {
        return new Pkcs12Nested(item);
    }

    public Pkcs12Nested<A> editPkcs12() {
        return this.withNewPkcs12Like(Optional.ofNullable(this.buildPkcs12()).orElse(null));
    }

    public Pkcs12Nested<A> editOrNewPkcs12() {
        return this.withNewPkcs12Like(Optional.ofNullable(this.buildPkcs12()).orElse(new CertificateKeystoreBuilder().build()));
    }

    public Pkcs12Nested<A> editOrNewPkcs12Like(CertificateKeystore item) {
        return this.withNewPkcs12Like(Optional.ofNullable(this.buildPkcs12()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateKeystoresFluent that = (CertificateKeystoresFluent)((Object)o);
        if (!Objects.equals((Object)this.jks, (Object)that.jks)) {
            return false;
        }
        return Objects.equals((Object)this.pkcs12, (Object)that.pkcs12);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jks, this.pkcs12, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jks != null) {
            sb.append("jks:");
            sb.append((Object)((Object)this.jks) + ",");
        }
        if (this.pkcs12 != null) {
            sb.append("pkcs12:");
            sb.append((Object)this.pkcs12);
        }
        sb.append("}");
        return sb.toString();
    }

    public class Pkcs12Nested<N>
    extends CertificateKeystoreFluent<Pkcs12Nested<N>>
    implements Nested<N> {
        CertificateKeystoreBuilder builder;

        Pkcs12Nested(CertificateKeystore item) {
            this.builder = new CertificateKeystoreBuilder(this, item);
        }

        public N and() {
            return (N)CertificateKeystoresFluent.this.withPkcs12(this.builder.build());
        }

        public N endPkcs12() {
            return this.and();
        }
    }

    public class JksNested<N>
    extends CertificateKeystoreFluent<JksNested<N>>
    implements Nested<N> {
        CertificateKeystoreBuilder builder;

        JksNested(CertificateKeystore item) {
            this.builder = new CertificateKeystoreBuilder(this, item);
        }

        public N and() {
            return (N)CertificateKeystoresFluent.this.withJks(this.builder.build());
        }

        public N endJks() {
            return this.and();
        }
    }
}

