/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.coordination.v1beta1.Lease;
import io.dekorate.deps.kubernetes.api.model.coordination.v1beta1.LeaseBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.internal.LeaseOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class LeaseHandler
implements ResourceHandler<Lease, LeaseBuilder> {
    @Override
    public String getKind() {
        return Lease.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "coordination.k8s.io/v1beta1";
    }

    @Override
    public Lease create(OkHttpClient client, Config config, String namespace, Lease item) {
        return (Lease)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Lease[0]);
    }

    @Override
    public Lease replace(OkHttpClient client, Config config, String namespace, Lease item) {
        return (Lease)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Lease reload(OkHttpClient client, Config config, String namespace, Lease item) {
        return (Lease)((Gettable)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public LeaseBuilder edit(Lease item) {
        return new LeaseBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Lease item) {
        return (Boolean)new LeaseOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Lease item, Watcher<Lease> watcher) {
        return (Watch)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Lease item, String resourceVersion, Watcher<Lease> watcher) {
        return (Watch)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Lease waitUntilReady(OkHttpClient client, Config config, String namespace, Lease item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Lease)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Lease waitUntilCondition(OkHttpClient client, Config config, String namespace, Lease item, Predicate<Lease> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Lease)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

