/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.model.ExternalMetricSource;
import io.dekorate.deps.kubernetes.api.model.ExternalMetricSourceFluent;
import io.dekorate.deps.kubernetes.api.model.LabelSelector;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorBuilder;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorFluentImpl;
import io.dekorate.deps.kubernetes.api.model.Quantity;
import io.dekorate.deps.kubernetes.api.model.QuantityBuilder;
import io.dekorate.deps.kubernetes.api.model.QuantityFluentImpl;

public class ExternalMetricSourceFluentImpl<A extends ExternalMetricSourceFluent<A>>
extends BaseFluent<A>
implements ExternalMetricSourceFluent<A> {
    private String metricName;
    private LabelSelectorBuilder metricSelector;
    private QuantityBuilder targetAverageValue;
    private QuantityBuilder targetValue;

    public ExternalMetricSourceFluentImpl() {
    }

    public ExternalMetricSourceFluentImpl(ExternalMetricSource instance) {
        this.withMetricName(instance.getMetricName());
        this.withMetricSelector(instance.getMetricSelector());
        this.withTargetAverageValue(instance.getTargetAverageValue());
        this.withTargetValue(instance.getTargetValue());
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    public A withNewMetricName(String arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuilder arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuffer arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    @Deprecated
    public LabelSelector getMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public LabelSelector buildMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public A withMetricSelector(LabelSelector metricSelector) {
        this._visitables.get("metricSelector").remove(this.metricSelector);
        if (metricSelector != null) {
            this.metricSelector = new LabelSelectorBuilder(metricSelector);
            this._visitables.get("metricSelector").add(this.metricSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelector() {
        return new MetricSelectorNestedImpl();
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
        return new MetricSelectorNestedImpl(item);
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector());
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : item);
    }

    @Override
    @Deprecated
    public Quantity getTargetAverageValue() {
        return this.targetAverageValue != null ? this.targetAverageValue.build() : null;
    }

    @Override
    public Quantity buildTargetAverageValue() {
        return this.targetAverageValue != null ? this.targetAverageValue.build() : null;
    }

    @Override
    public A withTargetAverageValue(Quantity targetAverageValue) {
        this._visitables.get("targetAverageValue").remove(this.targetAverageValue);
        if (targetAverageValue != null) {
            this.targetAverageValue = new QuantityBuilder(targetAverageValue);
            this._visitables.get("targetAverageValue").add(this.targetAverageValue);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    @Override
    public A withNewTargetAverageValue(String amount, String format) {
        return this.withTargetAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetAverageValue(String amount) {
        return this.withTargetAverageValue(new Quantity(amount));
    }

    @Override
    public ExternalMetricSourceFluent.TargetAverageValueNested<A> withNewTargetAverageValue() {
        return new TargetAverageValueNestedImpl();
    }

    @Override
    public ExternalMetricSourceFluent.TargetAverageValueNested<A> withNewTargetAverageValueLike(Quantity item) {
        return new TargetAverageValueNestedImpl(item);
    }

    @Override
    public ExternalMetricSourceFluent.TargetAverageValueNested<A> editTargetAverageValue() {
        return this.withNewTargetAverageValueLike(this.getTargetAverageValue());
    }

    @Override
    public ExternalMetricSourceFluent.TargetAverageValueNested<A> editOrNewTargetAverageValue() {
        return this.withNewTargetAverageValueLike(this.getTargetAverageValue() != null ? this.getTargetAverageValue() : new QuantityBuilder().build());
    }

    @Override
    public ExternalMetricSourceFluent.TargetAverageValueNested<A> editOrNewTargetAverageValueLike(Quantity item) {
        return this.withNewTargetAverageValueLike(this.getTargetAverageValue() != null ? this.getTargetAverageValue() : item);
    }

    @Override
    @Deprecated
    public Quantity getTargetValue() {
        return this.targetValue != null ? this.targetValue.build() : null;
    }

    @Override
    public Quantity buildTargetValue() {
        return this.targetValue != null ? this.targetValue.build() : null;
    }

    @Override
    public A withTargetValue(Quantity targetValue) {
        this._visitables.get("targetValue").remove(this.targetValue);
        if (targetValue != null) {
            this.targetValue = new QuantityBuilder(targetValue);
            this._visitables.get("targetValue").add(this.targetValue);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetValue() {
        return this.targetValue != null;
    }

    @Override
    public A withNewTargetValue(String amount, String format) {
        return this.withTargetValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetValue(String amount) {
        return this.withTargetValue(new Quantity(amount));
    }

    @Override
    public ExternalMetricSourceFluent.TargetValueNested<A> withNewTargetValue() {
        return new TargetValueNestedImpl();
    }

    @Override
    public ExternalMetricSourceFluent.TargetValueNested<A> withNewTargetValueLike(Quantity item) {
        return new TargetValueNestedImpl(item);
    }

    @Override
    public ExternalMetricSourceFluent.TargetValueNested<A> editTargetValue() {
        return this.withNewTargetValueLike(this.getTargetValue());
    }

    @Override
    public ExternalMetricSourceFluent.TargetValueNested<A> editOrNewTargetValue() {
        return this.withNewTargetValueLike(this.getTargetValue() != null ? this.getTargetValue() : new QuantityBuilder().build());
    }

    @Override
    public ExternalMetricSourceFluent.TargetValueNested<A> editOrNewTargetValueLike(Quantity item) {
        return this.withNewTargetValueLike(this.getTargetValue() != null ? this.getTargetValue() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalMetricSourceFluentImpl that = (ExternalMetricSourceFluentImpl)o;
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        if (this.metricSelector != null ? !this.metricSelector.equals(that.metricSelector) : that.metricSelector != null) {
            return false;
        }
        if (this.targetAverageValue != null ? !this.targetAverageValue.equals(that.targetAverageValue) : that.targetAverageValue != null) {
            return false;
        }
        return !(this.targetValue != null ? !this.targetValue.equals(that.targetValue) : that.targetValue != null);
    }

    public class TargetValueNestedImpl<N>
    extends QuantityFluentImpl<ExternalMetricSourceFluent.TargetValueNested<N>>
    implements ExternalMetricSourceFluent.TargetValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        TargetValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        TargetValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExternalMetricSourceFluentImpl.this.withTargetValue(this.builder.build());
        }

        @Override
        public N endTargetValue() {
            return this.and();
        }
    }

    public class TargetAverageValueNestedImpl<N>
    extends QuantityFluentImpl<ExternalMetricSourceFluent.TargetAverageValueNested<N>>
    implements ExternalMetricSourceFluent.TargetAverageValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        TargetAverageValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        TargetAverageValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExternalMetricSourceFluentImpl.this.withTargetAverageValue(this.builder.build());
        }

        @Override
        public N endTargetAverageValue() {
            return this.and();
        }
    }

    public class MetricSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ExternalMetricSourceFluent.MetricSelectorNested<N>>
    implements ExternalMetricSourceFluent.MetricSelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        MetricSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        MetricSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExternalMetricSourceFluentImpl.this.withMetricSelector(this.builder.build());
        }

        @Override
        public N endMetricSelector() {
            return this.and();
        }
    }
}

