/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaFluentImpl;
import io.dekorate.deps.kubernetes.api.model.Secret;
import io.dekorate.deps.kubernetes.api.model.SecretFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class SecretFluentImpl<A extends SecretFluent<A>>
extends BaseFluent<A>
implements SecretFluent<A> {
    private String apiVersion;
    private Map<String, String> data;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Map<String, String> stringData;
    private String type;

    public SecretFluentImpl() {
    }

    public SecretFluentImpl(Secret instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withStringData(instance.getStringData());
        this.withType(instance.getType());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToData(String key, String value) {
        if (this.data == null && key != null && value != null) {
            this.data = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.data.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToData(Map<String, String> map) {
        if (this.data == null && map != null) {
            this.data = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.data.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromData(String key) {
        if (this.data == null) {
            return (A)this;
        }
        if (key != null && this.data != null) {
            this.data.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromData(Map<String, String> map) {
        if (this.data == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.data == null) continue;
                this.data.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public A withData(Map<String, String> data) {
        this.data = data == null ? null : new LinkedHashMap<String, String>(data);
        return (A)this;
    }

    @Override
    public Boolean hasData() {
        return this.data != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public SecretFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public SecretFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public SecretFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public SecretFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public SecretFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToStringData(String key, String value) {
        if (this.stringData == null && key != null && value != null) {
            this.stringData = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.stringData.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToStringData(Map<String, String> map) {
        if (this.stringData == null && map != null) {
            this.stringData = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.stringData.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromStringData(String key) {
        if (this.stringData == null) {
            return (A)this;
        }
        if (key != null && this.stringData != null) {
            this.stringData.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromStringData(Map<String, String> map) {
        if (this.stringData == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.stringData == null) continue;
                this.stringData.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getStringData() {
        return this.stringData;
    }

    @Override
    public A withStringData(Map<String, String> stringData) {
        this.stringData = stringData == null ? null : new LinkedHashMap<String, String>(stringData);
        return (A)this;
    }

    @Override
    public Boolean hasStringData() {
        return this.stringData != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public A withNewType(String arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuilder arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuffer arg1) {
        return this.withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretFluentImpl that = (SecretFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.stringData != null ? !this.stringData.equals(that.stringData) : that.stringData != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<SecretFluent.MetadataNested<N>>
    implements SecretFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecretFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

