/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.dsl.internal;

import io.dekorate.deps.kubernetes.api.model.metrics.v1beta1.NodeMetrics;
import io.dekorate.deps.kubernetes.api.model.metrics.v1beta1.NodeMetricsList;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationSupport;
import io.dekorate.deps.kubernetes.client.utils.URLUtils;
import io.dekorate.deps.okhttp3.OkHttpClient;

public class NodeMetricOperationsImpl
extends OperationSupport {
    private static String METRIC_ENDPOINT_URL = "apis/metrics.k8s.io/v1beta1/nodes";

    public NodeMetricOperationsImpl(OkHttpClient client, Config config) {
        super(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public NodeMetricsList metrics() {
        try {
            String resourceUrl = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL);
            return this.handleMetric(resourceUrl, NodeMetricsList.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public NodeMetrics metrics(String nodeName) {
        try {
            String resourceUrl = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL, nodeName);
            return this.handleMetric(resourceUrl, NodeMetrics.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

