/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.dsl.internal;

import io.dekorate.deps.jackson.databind.ObjectMapper;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.VersionInfo;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationSupport;
import io.dekorate.deps.kubernetes.client.utils.URLUtils;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.okhttp3.Request;
import io.dekorate.deps.okhttp3.Response;
import java.util.HashMap;
import java.util.Map;

public class ClusterOperationsImpl
extends OperationSupport {
    private String versionEndpoint;

    public ClusterOperationsImpl(OkHttpClient client, Config config, String item) {
        super(new OperationContext().withOkhttpClient(client).withConfig(config));
        this.versionEndpoint = item;
    }

    public VersionInfo fetchVersion() {
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(URLUtils.join(this.config.getMasterUrl(), this.versionEndpoint));
            Response response = this.client.newCall(requestBuilder.build()).execute();
            ObjectMapper objectMapper = new ObjectMapper();
            Map myMap = objectMapper.readValue(response.body().string(), HashMap.class);
            return new VersionInfo(myMap);
        }
        catch (Exception e) {
            KubernetesClientException.launderThrowable(e);
            return null;
        }
    }
}

