/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.informers.cache;

import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesResourceList;
import io.dekorate.deps.kubernetes.api.model.ListMeta;
import io.dekorate.deps.kubernetes.api.model.ListOptionsBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.kubernetes.client.informers.ListerWatcher;
import io.dekorate.deps.kubernetes.client.informers.cache.Store;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectorRunnable<T extends HasMetadata, TList extends KubernetesResourceList<T>>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ReflectorRunnable.class);
    private String lastSyncResourceVersion;
    private Watch watch;
    private ListerWatcher<T, TList> listerWatcher;
    private Store<T> store;
    private Class<T> apiTypeClass;
    private AtomicBoolean isActive = new AtomicBoolean(true);
    private OperationContext operationContext;

    public ReflectorRunnable(Class<T> apiTypeClass, ListerWatcher listerWatcher, Store store, OperationContext operationContext) {
        this.listerWatcher = listerWatcher;
        this.store = store;
        this.apiTypeClass = apiTypeClass;
        this.operationContext = operationContext;
    }

    @Override
    public void run() {
        try {
            log.info("{}#Start listing and watching...", this.apiTypeClass);
            KubernetesResourceList list = (KubernetesResourceList)this.listerWatcher.list(((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.FALSE)).withResourceVersion(null)).withTimeoutSeconds(null)).build(), null, this.operationContext);
            ListMeta listMeta = list.getMetadata();
            String resourceVersion = listMeta.getResourceVersion();
            List items = list.getItems();
            if (log.isDebugEnabled()) {
                log.debug("{}#Extract resourceVersion {} list meta", this.apiTypeClass, (Object)resourceVersion);
            }
            this.syncWith(items, resourceVersion);
            this.lastSyncResourceVersion = resourceVersion;
            if (log.isDebugEnabled()) {
                log.debug("{}#Start watching with {}...", this.apiTypeClass, (Object)this.lastSyncResourceVersion);
            }
            if (!this.isActive.get() && this.watch != null) {
                log.info("Closing watch");
                this.watch.close();
                return;
            }
            if (this.watch != null) {
                log.info("Closing existing watch and waiting");
                this.watch.close();
            }
            try {
                this.watch = this.listerWatcher.watch(((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.TRUE)).withResourceVersion(resourceVersion)).withTimeoutSeconds(null)).build(), null, this.operationContext, new Watcher<T>(){

                    @Override
                    public void eventReceived(Watcher.Action action, T resource) {
                        log.info("Event received ", (Object)action.name());
                        if (action == null) {
                            log.error("unrecognized event {}", resource);
                        }
                        if (action == Watcher.Action.ERROR) {
                            String errorMessage = String.format("got ERROR event for ", resource.getMetadata().getName());
                            log.error(errorMessage);
                            throw new RuntimeException(errorMessage);
                        }
                        ObjectMeta meta = resource.getMetadata();
                        String newResourceVersion = meta.getResourceVersion();
                        switch (action) {
                            case ADDED: {
                                ReflectorRunnable.this.store.add(resource);
                                break;
                            }
                            case MODIFIED: {
                                ReflectorRunnable.this.store.update(resource);
                                break;
                            }
                            case DELETED: {
                                ReflectorRunnable.this.store.delete(resource);
                            }
                        }
                        ReflectorRunnable.this.lastSyncResourceVersion = newResourceVersion;
                        if (log.isDebugEnabled()) {
                            log.debug("{}#Receiving resourceVersion {}", (Object)ReflectorRunnable.this.apiTypeClass, (Object)ReflectorRunnable.this.lastSyncResourceVersion);
                        }
                    }

                    @Override
                    public void onClose(KubernetesClientException exception) {
                        log.error("Watch closing.");
                        if (exception != null) {
                            exception.printStackTrace();
                            log.error("watch closed due to  " + exception.getMessage());
                        }
                    }
                });
            }
            catch (Throwable t) {
                log.info("{}#Watch connection got exception {}", this.apiTypeClass, (Object)t.getMessage());
            }
        }
        catch (Exception exception) {
            log.error("Failure in list-watch: {}", (Object)exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void stop() {
        this.isActive.set(false);
    }

    private void syncWith(List<T> items, String resourceVersion) {
        this.store.replace(items, resourceVersion);
    }

    public String getLastSyncResourceVersion() {
        return this.lastSyncResourceVersion;
    }
}

