/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.dsl.internal;

import io.dekorate.deps.kubernetes.api.model.DoneableReplicationController;
import io.dekorate.deps.kubernetes.api.model.PodList;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpecFluent;
import io.dekorate.deps.kubernetes.api.model.ReplicationController;
import io.dekorate.deps.kubernetes.api.model.ReplicationControllerBuilder;
import io.dekorate.deps.kubernetes.api.model.ReplicationControllerFluent;
import io.dekorate.deps.kubernetes.api.model.ReplicationControllerList;
import io.dekorate.deps.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.dsl.FilterWatchListDeletable;
import io.dekorate.deps.kubernetes.client.dsl.NonNamespaceOperation;
import io.dekorate.deps.kubernetes.client.dsl.Operation;
import io.dekorate.deps.kubernetes.client.dsl.RollableScalableResource;
import io.dekorate.deps.kubernetes.client.dsl.internal.ReplicationControllerOperationsImpl;
import io.dekorate.deps.kubernetes.client.dsl.internal.RollingUpdater;
import io.dekorate.deps.okhttp3.OkHttpClient;

class ReplicationControllerRollingUpdater
extends RollingUpdater<ReplicationController, ReplicationControllerList, DoneableReplicationController> {
    ReplicationControllerRollingUpdater(OkHttpClient client, Config config, String namespace) {
        super(client, config, namespace);
    }

    ReplicationControllerRollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, config, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected ReplicationController createClone(ReplicationController obj, String newName, String newDeploymentHash) {
        return ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).addToSelector("deployment", newDeploymentHash)).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected PodList listSelectedPods(ReplicationController obj) {
        return (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.pods().inNamespace(this.namespace)).withLabels(obj.getSpec().getSelector())).list();
    }

    @Override
    protected void updateDeploymentKey(DoneableReplicationController obj, String hash) {
        ((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)obj.editSpec().addToSelector("deployment", hash)).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected void removeDeploymentKey(DoneableReplicationController obj) {
        ((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)obj.editSpec().removeFromSelector("deployment")).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected int getReplicas(ReplicationController obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected ReplicationController setReplicas(ReplicationController obj, int replicas) {
        return ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected Operation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> resources() {
        return new ReplicationControllerOperationsImpl(this.client, this.config);
    }
}

