/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.Pod;
import io.dekorate.deps.kubernetes.api.model.PodBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.PodResource;
import io.dekorate.deps.kubernetes.client.dsl.internal.PodOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class PodHandler
implements ResourceHandler<Pod, PodBuilder> {
    @Override
    public String getKind() {
        return Pod.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Pod create(OkHttpClient client, Config config, String namespace, Pod item) {
        return (Pod)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Pod[0]);
    }

    @Override
    public Pod replace(OkHttpClient client, Config config, String namespace, Pod item) {
        return (Pod)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Pod reload(OkHttpClient client, Config config, String namespace, Pod item) {
        return (Pod)((Gettable)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public PodBuilder edit(Pod item) {
        return new PodBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Pod item) {
        return (Boolean)new PodOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Pod item, Watcher<Pod> watcher) {
        return (Watch)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Pod item, String resourceVersion, Watcher<Pod> watcher) {
        return (Watch)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Pod waitUntilReady(OkHttpClient client, Config config, String namespace, Pod item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Pod)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Pod waitUntilCondition(OkHttpClient client, Config config, String namespace, Pod item, Predicate<Pod> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Pod)((PodResource)new PodOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

