/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.Secret;
import io.dekorate.deps.kubernetes.api.model.SecretBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.internal.SecretOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class SecretHandler
implements ResourceHandler<Secret, SecretBuilder> {
    @Override
    public String getKind() {
        return Secret.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Secret create(OkHttpClient client, Config config, String namespace, Secret item) {
        return (Secret)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Secret[0]);
    }

    @Override
    public Secret replace(OkHttpClient client, Config config, String namespace, Secret item) {
        return (Secret)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Secret reload(OkHttpClient client, Config config, String namespace, Secret item) {
        return (Secret)((Gettable)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public SecretBuilder edit(Secret item) {
        return new SecretBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Secret item) {
        return (Boolean)new SecretOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Secret item, Watcher<Secret> watcher) {
        return (Watch)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Secret item, String resourceVersion, Watcher<Secret> watcher) {
        return (Watch)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Secret waitUntilReady(OkHttpClient client, Config config, String namespace, Secret item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Secret)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Secret waitUntilCondition(OkHttpClient client, Config config, String namespace, Secret item, Predicate<Secret> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Secret)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

