/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.informers;

import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesResourceList;
import io.dekorate.deps.kubernetes.api.model.ListOptions;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.base.BaseOperation;
import io.dekorate.deps.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.kubernetes.client.informers.ListerWatcher;
import io.dekorate.deps.kubernetes.client.informers.SharedIndexInformer;
import io.dekorate.deps.kubernetes.client.informers.impl.DefaultSharedIndexInformer;
import io.dekorate.deps.kubernetes.client.utils.Utils;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class SharedInformerFactory
extends BaseOperation {
    private Map<Type, SharedIndexInformer> informers;
    private Map<Type, Future> startedInformers;
    private ExecutorService informerExecutor;
    private BaseOperation baseOperation;

    public SharedInformerFactory(ExecutorService threadPool, OkHttpClient okHttpClient, Config configuration) {
        super(new OperationContext().withOkhttpClient(okHttpClient).withConfig(configuration));
        this.informerExecutor = threadPool;
        this.informers = new HashMap<Type, SharedIndexInformer>();
        this.startedInformers = new HashMap<Type, Future>();
        this.baseOperation = this.newInstance(this.context);
    }

    public synchronized <T extends HasMetadata, TList extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<TList> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, this.context.withPlural(Utils.getPluralFromKind(apiTypeClass.getSimpleName())), resyncPeriodInMillis);
    }

    public synchronized <T extends HasMetadata, TList extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(CustomResourceDefinitionContext customResourceContext, Class<T> apiTypeClass, Class<TList> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, this.context.withApiGroupVersion(customResourceContext.getVersion()).withApiGroupName(customResourceContext.getGroup()).withPlural(customResourceContext.getPlural()), resyncPeriodInMillis);
    }

    public synchronized <T extends HasMetadata, TList extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<TList> apiListTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        ListerWatcher<T, TList> listerWatcher = this.listerWatcherFor(apiTypeClass, apiListTypeClass);
        DefaultSharedIndexInformer informer = new DefaultSharedIndexInformer(apiTypeClass, listerWatcher, resyncPeriodInMillis, operationContext);
        this.informers.put(apiTypeClass, informer);
        return informer;
    }

    private <T extends HasMetadata, TList extends KubernetesResourceList<T>> ListerWatcher<T, TList> listerWatcherFor(final Class<T> apiTypeClass, final Class<TList> apiListTypeClass) {
        return new ListerWatcher<T, TList>(){

            @Override
            public TList list(ListOptions params, String namespace, OperationContext context) throws KubernetesClientException {
                BaseOperation listBaseOperation = SharedInformerFactory.this.baseOperation.newInstance(context.withNamespace(namespace));
                listBaseOperation.setType(apiTypeClass);
                listBaseOperation.setListType(apiListTypeClass);
                return listBaseOperation.list();
            }

            @Override
            public Watch watch(ListOptions params, String namespace, OperationContext context, Watcher<T> resourceWatcher) throws KubernetesClientException {
                BaseOperation watchBaseOperation = SharedInformerFactory.this.baseOperation.newInstance(context);
                watchBaseOperation.setType(apiTypeClass);
                watchBaseOperation.setListType(apiListTypeClass);
                return watchBaseOperation.watch(params.getResourceVersion(), resourceWatcher, true);
            }
        };
    }

    public synchronized <T> SharedIndexInformer<T> getExistingSharedIndexInformer(Class<T> apiTypeClass) {
        return this.informers.get(apiTypeClass);
    }

    public synchronized void startAllRegisteredInformers() {
        if (this.informers == null || this.informers.isEmpty()) {
            return;
        }
        this.informers.forEach((informerType, informer) -> {
            if (!this.startedInformers.containsKey(informerType)) {
                this.startedInformers.put((Type)informerType, this.informerExecutor.submit(informer::run));
            }
        });
    }

    public synchronized void stopAllRegisteredInformers() {
        if (this.informers == null || this.informers.isEmpty()) {
            return;
        }
        this.informers.forEach((informerType, informer) -> {
            if (this.startedInformers.containsKey(informerType)) {
                this.startedInformers.remove(informerType);
                informer.stop();
            }
        });
        this.informerExecutor.shutdown();
    }
}

