/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.jackson.dataformat.javaprop;

import io.dekorate.deps.jackson.core.JsonParser;
import io.dekorate.deps.jackson.core.Version;
import io.dekorate.deps.jackson.databind.JavaType;
import io.dekorate.deps.jackson.databind.ObjectMapper;
import io.dekorate.deps.jackson.dataformat.javaprop.JavaPropsFactory;
import io.dekorate.deps.jackson.dataformat.javaprop.JavaPropsGenerator;
import io.dekorate.deps.jackson.dataformat.javaprop.JavaPropsParser;
import io.dekorate.deps.jackson.dataformat.javaprop.JavaPropsSchema;
import io.dekorate.deps.jackson.dataformat.javaprop.PackageVersion;
import java.io.IOException;
import java.util.Properties;

public class JavaPropsMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public JavaPropsMapper() {
        this(new JavaPropsFactory());
    }

    public JavaPropsMapper(JavaPropsFactory f) {
        super(f);
    }

    protected JavaPropsMapper(JavaPropsMapper src) {
        super(src);
    }

    @Override
    public JavaPropsMapper copy() {
        this._checkInvalidCopy(JavaPropsMapper.class);
        return new JavaPropsMapper(this);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JavaPropsFactory getFactory() {
        return (JavaPropsFactory)this._jsonFactory;
    }

    public <T> T readPropertiesAs(Properties props, JavaPropsSchema schema, Class<T> valueType) throws IOException {
        JavaPropsParser p = this.getFactory().createParser(props);
        ((JsonParser)p).setSchema(schema);
        return this.readValue((JsonParser)p, valueType);
    }

    public <T> T readPropertiesAs(Properties props, JavaPropsSchema schema, JavaType valueType) throws IOException {
        JavaPropsParser p = this.getFactory().createParser(props);
        ((JsonParser)p).setSchema(schema);
        return this.readValue((JsonParser)p, valueType);
    }

    public <T> T readPropertiesAs(Properties props, Class<T> valueType) throws IOException {
        return this.readPropertiesAs(props, JavaPropsSchema.emptySchema(), valueType);
    }

    public <T> T readPropertiesAs(Properties props, JavaType valueType) throws IOException {
        return this.readPropertiesAs(props, JavaPropsSchema.emptySchema(), valueType);
    }

    public <T> T readSystemPropertiesAs(JavaPropsSchema schema, Class<T> valueType) throws IOException {
        return this.readPropertiesAs(System.getProperties(), schema, valueType);
    }

    public <T> T readSystemPropertiesAs(JavaPropsSchema schema, JavaType valueType) throws IOException {
        return this.readPropertiesAs(System.getProperties(), schema, valueType);
    }

    public <T> T readEnvVariablesAs(JavaPropsSchema schema, Class<T> valueType) throws IOException {
        return this.readPropertiesAs(this._env(), schema, valueType);
    }

    public <T> T readEnvVariablesAs(JavaPropsSchema schema, JavaType valueType) throws IOException {
        return this.readPropertiesAs(this._env(), schema, valueType);
    }

    protected Properties _env() {
        Properties props = new Properties();
        props.putAll(System.getenv());
        return props;
    }

    public void writeValue(Properties targetProps, Object value) throws IOException {
        if (targetProps == null) {
            throw new IllegalArgumentException("Can not pass null Properties as target");
        }
        JavaPropsGenerator g = this.getFactory().createGenerator(targetProps);
        this.writeValue(g, value);
        g.close();
    }

    public void writeValue(Properties targetProps, Object value, JavaPropsSchema schema) throws IOException {
        if (targetProps == null) {
            throw new IllegalArgumentException("Can not pass null Properties as target");
        }
        JavaPropsGenerator g = this.getFactory().createGenerator(targetProps);
        if (schema != null) {
            g.setSchema(schema);
        }
        this.writeValue(g, value);
        g.close();
    }

    public Properties writeValueAsProperties(Object value) throws IOException {
        Properties props = new Properties();
        this.writeValue(props, value);
        return props;
    }

    public Properties writeValueAsProperties(Object value, JavaPropsSchema schema) throws IOException {
        Properties props = new Properties();
        this.writeValue(props, value, schema);
        return props;
    }
}

