/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.client.internal;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.dsl.base.BaseOperation;
import io.dekorate.deps.kubernetes.client.dsl.base.HasMetadataOperation;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.servicecatalog.api.model.ClusterServicePlan;
import io.dekorate.deps.servicecatalog.api.model.ClusterServicePlanList;
import io.dekorate.deps.servicecatalog.api.model.DoneableClusterServicePlan;
import io.dekorate.deps.servicecatalog.api.model.DoneableServiceInstance;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstance;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstanceFluent;
import io.dekorate.deps.servicecatalog.client.internal.ClusterServicePlanResource;
import io.dekorate.deps.servicecatalog.client.internal.ServiceInstanceOperationsImpl;
import io.dekorate.deps.servicecatalog.client.internal.ServiceInstanceResource;

public class ClusterServicePlanOperationsImpl
extends HasMetadataOperation<ClusterServicePlan, ClusterServicePlanList, DoneableClusterServicePlan, ClusterServicePlanResource>
implements ClusterServicePlanResource {
    public ClusterServicePlanOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ClusterServicePlanOperationsImpl(OperationContext ctx) {
        super(ctx.withApiGroupName("servicecatalog.k8s.io").withApiGroupVersion("v1beta1").withPlural("clusterserviceplans"));
        this.type = ClusterServicePlan.class;
        this.listType = ClusterServicePlanList.class;
        this.doneableType = DoneableClusterServicePlan.class;
    }

    @Override
    public BaseOperation<ClusterServicePlan, ClusterServicePlanList, DoneableClusterServicePlan, ClusterServicePlanResource> newInstance(OperationContext context) {
        return new ClusterServicePlanOperationsImpl(context);
    }

    @Override
    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public ServiceInstance instantiate(String ... args) {
        String instanceNamespace;
        String instanceName;
        if (args.length == 1) {
            instanceName = args[0];
            instanceNamespace = this.config.getNamespace();
        } else if (args.length == 2) {
            instanceNamespace = args[0];
            instanceName = args[1];
        } else {
            throw new IllegalArgumentException("Instantiate needs to be called with either <namespace> <instance name> or <instance name> arguments, but instead found: " + args.length + " arguments.");
        }
        ClusterServicePlan item = (ClusterServicePlan)this.get();
        return ((DoneableServiceInstance)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((DoneableServiceInstance)((ServiceInstanceFluent.MetadataNested)((ServiceInstanceFluent.MetadataNested)((DoneableServiceInstance)new ServiceInstanceOperationsImpl(this.context.withItem(null)).createNew()).withNewMetadata().withName(instanceName)).withNamespace(instanceNamespace)).endMetadata()).withNewSpec().withClusterServiceClassName(item.getSpec().getClusterServiceClassRef().getName())).withClusterServicePlanName(item.getMetadata().getName())).endSpec()).done();
    }

    @Override
    public ServiceInstanceResource instantiateAnd(String ... args) {
        ServiceInstance item = this.instantiate(args);
        return new ServiceInstanceOperationsImpl(this.context.withItem(item));
    }
}

