/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client;

import io.dekorate.deps.kubernetes.api.model.ComponentStatus;
import io.dekorate.deps.kubernetes.api.model.ComponentStatusList;
import io.dekorate.deps.kubernetes.api.model.ConfigMap;
import io.dekorate.deps.kubernetes.api.model.ConfigMapList;
import io.dekorate.deps.kubernetes.api.model.DoneableComponentStatus;
import io.dekorate.deps.kubernetes.api.model.DoneableConfigMap;
import io.dekorate.deps.kubernetes.api.model.DoneableEndpoints;
import io.dekorate.deps.kubernetes.api.model.DoneableEvent;
import io.dekorate.deps.kubernetes.api.model.DoneableLimitRange;
import io.dekorate.deps.kubernetes.api.model.DoneableNamespace;
import io.dekorate.deps.kubernetes.api.model.DoneableNode;
import io.dekorate.deps.kubernetes.api.model.DoneablePersistentVolume;
import io.dekorate.deps.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.dekorate.deps.kubernetes.api.model.DoneablePod;
import io.dekorate.deps.kubernetes.api.model.DoneableReplicationController;
import io.dekorate.deps.kubernetes.api.model.DoneableResourceQuota;
import io.dekorate.deps.kubernetes.api.model.DoneableSecret;
import io.dekorate.deps.kubernetes.api.model.DoneableService;
import io.dekorate.deps.kubernetes.api.model.DoneableServiceAccount;
import io.dekorate.deps.kubernetes.api.model.Endpoints;
import io.dekorate.deps.kubernetes.api.model.EndpointsList;
import io.dekorate.deps.kubernetes.api.model.Event;
import io.dekorate.deps.kubernetes.api.model.EventList;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesResourceList;
import io.dekorate.deps.kubernetes.api.model.LimitRange;
import io.dekorate.deps.kubernetes.api.model.LimitRangeList;
import io.dekorate.deps.kubernetes.api.model.Namespace;
import io.dekorate.deps.kubernetes.api.model.NamespaceList;
import io.dekorate.deps.kubernetes.api.model.Node;
import io.dekorate.deps.kubernetes.api.model.NodeList;
import io.dekorate.deps.kubernetes.api.model.PersistentVolume;
import io.dekorate.deps.kubernetes.api.model.PersistentVolumeClaim;
import io.dekorate.deps.kubernetes.api.model.PersistentVolumeClaimList;
import io.dekorate.deps.kubernetes.api.model.PersistentVolumeList;
import io.dekorate.deps.kubernetes.api.model.Pod;
import io.dekorate.deps.kubernetes.api.model.PodList;
import io.dekorate.deps.kubernetes.api.model.ReplicationController;
import io.dekorate.deps.kubernetes.api.model.ReplicationControllerList;
import io.dekorate.deps.kubernetes.api.model.ResourceQuota;
import io.dekorate.deps.kubernetes.api.model.ResourceQuotaList;
import io.dekorate.deps.kubernetes.api.model.RootPaths;
import io.dekorate.deps.kubernetes.api.model.Secret;
import io.dekorate.deps.kubernetes.api.model.SecretList;
import io.dekorate.deps.kubernetes.api.model.Service;
import io.dekorate.deps.kubernetes.api.model.ServiceAccount;
import io.dekorate.deps.kubernetes.api.model.ServiceAccountList;
import io.dekorate.deps.kubernetes.api.model.ServiceList;
import io.dekorate.deps.kubernetes.client.Adapters;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ConfigBuilder;
import io.dekorate.deps.kubernetes.client.DefaultKubernetesClient;
import io.dekorate.deps.kubernetes.client.ExtensionAdapter;
import io.dekorate.deps.kubernetes.client.KubernetesClient;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.NamespacedKubernetesClient;
import io.dekorate.deps.kubernetes.client.VersionInfo;
import io.dekorate.deps.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.BatchAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.dekorate.deps.kubernetes.client.dsl.MixedOperation;
import io.dekorate.deps.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.dekorate.deps.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.dekorate.deps.kubernetes.client.dsl.NetworkAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.NonNamespaceOperation;
import io.dekorate.deps.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.dekorate.deps.kubernetes.client.dsl.PodResource;
import io.dekorate.deps.kubernetes.client.dsl.PolicyAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.RbacAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.RollableScalableResource;
import io.dekorate.deps.kubernetes.client.dsl.ServiceResource;
import io.dekorate.deps.kubernetes.client.dsl.StorageAPIGroupDSL;
import io.dekorate.deps.kubernetes.client.dsl.SubjectAccessReviewDSL;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.io.InputStream;
import java.net.URL;

public class AutoAdaptableKubernetesClient
extends DefaultKubernetesClient {
    private KubernetesClient delegate;

    public AutoAdaptableKubernetesClient() throws KubernetesClientException {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient());
    }

    public AutoAdaptableKubernetesClient(OkHttpClient httpClient, Config config) throws KubernetesClientException {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(httpClient, config));
    }

    public AutoAdaptableKubernetesClient(Config config) throws KubernetesClientException {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(config));
    }

    public AutoAdaptableKubernetesClient(String masterUrl) throws KubernetesClientException {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(masterUrl));
    }

    public static KubernetesClient adapt(KubernetesClient initial) {
        KubernetesClient result = initial;
        for (ExtensionAdapter<KubernetesClient> adapter : Adapters.list(KubernetesClient.class)) {
            if (!adapter.isAdaptable(result).booleanValue()) continue;
            result = adapter.adapt(result);
        }
        return result;
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new AutoAdaptableKubernetesClient(this.httpClient, updated);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public VersionInfo getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.delegate.network();
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.delegate.storage();
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.delegate.batch();
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.delegate.policy();
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.delegate.rbac();
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, DoneableService, ServiceResource<Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public SubjectAccessReviewDSL subjectAccessReviewAuth() {
        return this.delegate.subjectAccessReviewAuth();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        return this.delegate.isAdaptable(type);
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }
}

