/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.batch.Job;
import io.dekorate.deps.kubernetes.api.model.batch.JobBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.ScalableResource;
import io.dekorate.deps.kubernetes.client.dsl.internal.JobOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class JobHandler
implements ResourceHandler<Job, JobBuilder> {
    @Override
    public String getKind() {
        return Job.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "batch/v1";
    }

    @Override
    public Job create(OkHttpClient client, Config config, String namespace, Job item) {
        return (Job)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Job[0]);
    }

    @Override
    public Job replace(OkHttpClient client, Config config, String namespace, Job item) {
        return (Job)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Job reload(OkHttpClient client, Config config, String namespace, Job item) {
        return (Job)((Gettable)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public JobBuilder edit(Job item) {
        return new JobBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Job item) {
        return (Boolean)new JobOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Job item, Watcher<Job> watcher) {
        return (Watch)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Job item, String resourceVersion, Watcher<Job> watcher) {
        return (Watch)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Job waitUntilReady(OkHttpClient client, Config config, String namespace, Job item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Job)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Job waitUntilCondition(OkHttpClient client, Config config, String namespace, Job item, Predicate<Job> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Job)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

