/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.tekton.client;

import io.dekorate.deps.kubernetes.api.model.RootPaths;
import io.dekorate.deps.kubernetes.client.Client;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ExtensionAdapter;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.tekton.client.DefaultTektonClient;
import io.dekorate.deps.tekton.client.TektonClient;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TektonExtensionAdapter
implements ExtensionAdapter<TektonClient> {
    static final ConcurrentMap<URL, Boolean> IS_TEKTON = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_TEKTON_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    @Override
    public Class<TektonClient> getExtensionType() {
        return TektonClient.class;
    }

    @Override
    public Boolean isAdaptable(Client client) {
        return this.isTektonAvailable(client);
    }

    @Override
    public TektonClient adapt(Client client) {
        return new DefaultTektonClient(client.adapt(OkHttpClient.class), (Config)client.getConfiguration());
    }

    private boolean isTektonAvailable(Client client) {
        List<String> paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_TEKTON.containsKey(masterUrl)) {
            return (Boolean)IS_TEKTON.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith("tekton.dev") && !path.contains("tekton.dev/")) continue;
                USES_TEKTON_APIGROUPS.putIfAbsent(masterUrl, true);
                IS_TEKTON.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_TEKTON.putIfAbsent(masterUrl, false);
        return false;
    }
}

