/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.tekton.pipeline.v1alpha1;

import io.dekorate.deps.jackson.annotation.JsonAnyGetter;
import io.dekorate.deps.jackson.annotation.JsonAnySetter;
import io.dekorate.deps.jackson.annotation.JsonIgnore;
import io.dekorate.deps.jackson.annotation.JsonInclude;
import io.dekorate.deps.jackson.annotation.JsonProperty;
import io.dekorate.deps.jackson.annotation.JsonPropertyOrder;
import io.dekorate.deps.jackson.core.JsonGenerator;
import io.dekorate.deps.jackson.core.JsonParser;
import io.dekorate.deps.jackson.core.JsonProcessingException;
import io.dekorate.deps.jackson.core.ObjectCodec;
import io.dekorate.deps.jackson.databind.DeserializationContext;
import io.dekorate.deps.jackson.databind.JsonDeserializer;
import io.dekorate.deps.jackson.databind.JsonNode;
import io.dekorate.deps.jackson.databind.JsonSerializer;
import io.dekorate.deps.jackson.databind.SerializerProvider;
import io.dekorate.deps.jackson.databind.annotation.JsonDeserialize;
import io.dekorate.deps.jackson.databind.annotation.JsonSerialize;
import io.dekorate.deps.kubernetes.api.model.KubernetesResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"arrayVal", "stringVal", "type"})
@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class ArrayOrString
implements KubernetesResource {
    private static final String TYPE_STRING = "string";
    private static final String TYPE_ARRAY = "array";
    @JsonProperty(value="arrayVal")
    private List<String> arrayVal = new ArrayList<String>();
    @JsonProperty(value="stringVal")
    private String stringVal;
    @JsonProperty(value="type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ArrayOrString() {
    }

    public ArrayOrString(List<String> arrayVal, String stringVal, String type, Map<String, Object> additionalProperties) {
        this.arrayVal = arrayVal;
        this.stringVal = stringVal;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    public ArrayOrString(String stringVal) {
        this(null, stringVal, TYPE_STRING, new HashMap<String, Object>());
    }

    public ArrayOrString(List<String> arrayVal) {
        this(arrayVal, null, TYPE_ARRAY, new HashMap<String, Object>());
    }

    @JsonProperty(value="arrayVal")
    public List<String> getArrayVal() {
        return this.arrayVal;
    }

    @JsonProperty(value="arrayVal")
    public void setArrayVal(List<String> arrayVal) {
        this.arrayVal = arrayVal;
    }

    @JsonProperty(value="stringVal")
    public String getStringVal() {
        return this.stringVal;
    }

    @JsonProperty(value="stringVal")
    public void setStringVal(String stringVal) {
        this.stringVal = stringVal;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "ArrayOrString(arrayVal=" + this.getArrayVal() + ", stringVal=" + this.getStringVal() + ", type=" + this.getType() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayOrString)) {
            return false;
        }
        ArrayOrString other = (ArrayOrString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$arrayVal = this.getArrayVal();
        List<String> other$arrayVal = other.getArrayVal();
        if (this$arrayVal == null ? other$arrayVal != null : !((Object)this$arrayVal).equals(other$arrayVal)) {
            return false;
        }
        String this$stringVal = this.getStringVal();
        String other$stringVal = other.getStringVal();
        if (this$stringVal == null ? other$stringVal != null : !this$stringVal.equals(other$stringVal)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArrayOrString;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $arrayVal = this.getArrayVal();
        result = result * 59 + ($arrayVal == null ? 43 : ((Object)$arrayVal).hashCode());
        String $stringVal = this.getStringVal();
        result = result * 59 + ($stringVal == null ? 43 : $stringVal.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public static class Deserializer
    extends JsonDeserializer<ArrayOrString> {
        @Override
        public ArrayOrString deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            ArrayOrString arrayOrString;
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            if (node.isArray()) {
                ArrayList<String> elements = new ArrayList<String>();
                node.elements().forEachRemaining(n -> elements.add(n.asText()));
                arrayOrString = new ArrayOrString(elements);
            } else {
                arrayOrString = new ArrayOrString(node.asText());
            }
            return arrayOrString;
        }
    }

    public static class Serializer
    extends JsonSerializer<ArrayOrString> {
        @Override
        public void serialize(ArrayOrString value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                if (value.getType() == null) {
                    String stringVal = value.getStringVal();
                    if (stringVal != null) {
                        jgen.writeString(stringVal);
                    } else {
                        List<String> arrayVal = value.getArrayVal();
                        if (arrayVal != null) {
                            this.writeArray(value, jgen);
                        } else {
                            jgen.writeNull();
                        }
                    }
                } else if (Objects.equals(value.getType(), ArrayOrString.TYPE_STRING)) {
                    jgen.writeString(value.stringVal);
                } else if (Objects.equals(value.getType(), ArrayOrString.TYPE_ARRAY)) {
                    this.writeArray(value, jgen);
                } else {
                    jgen.writeNull();
                }
            } else {
                jgen.writeNull();
            }
        }

        private void writeArray(ArrayOrString value, JsonGenerator jgen) throws IOException {
            jgen.writeStartArray(value.getArrayVal().size());
            for (String n : value.getArrayVal()) {
                jgen.writeString(n);
            }
            jgen.writeEndArray();
        }
    }
}

