/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model.apiextensions;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceConversion;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceConversionFluent;
import io.dekorate.deps.kubernetes.api.model.apiextensions.CustomResourceConversionFluentImpl;

public class CustomResourceConversionBuilder
extends CustomResourceConversionFluentImpl<CustomResourceConversionBuilder>
implements VisitableBuilder<CustomResourceConversion, CustomResourceConversionBuilder> {
    CustomResourceConversionFluent<?> fluent;
    Boolean validationEnabled;

    public CustomResourceConversionBuilder() {
        this(true);
    }

    public CustomResourceConversionBuilder(Boolean validationEnabled) {
        this(new CustomResourceConversion(), validationEnabled);
    }

    public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CustomResourceConversion(), validationEnabled);
    }

    public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent, CustomResourceConversion instance) {
        this(fluent, instance, true);
    }

    public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent, CustomResourceConversion instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConversionReviewVersions(instance.getConversionReviewVersions());
        fluent.withStrategy(instance.getStrategy());
        fluent.withWebhookClientConfig(instance.getWebhookClientConfig());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceConversionBuilder(CustomResourceConversion instance) {
        this(instance, (Boolean)true);
    }

    public CustomResourceConversionBuilder(CustomResourceConversion instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConversionReviewVersions(instance.getConversionReviewVersions());
        this.withStrategy(instance.getStrategy());
        this.withWebhookClientConfig(instance.getWebhookClientConfig());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CustomResourceConversion build() {
        CustomResourceConversion buildable = new CustomResourceConversion(this.fluent.getConversionReviewVersions(), this.fluent.getStrategy(), this.fluent.getWebhookClientConfig());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceConversionBuilder that = (CustomResourceConversionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

