/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.extended.leaderelection.resourcelock;

import io.dekorate.deps.jackson.core.JsonProcessingException;
import io.dekorate.deps.jackson.core.type.TypeReference;
import io.dekorate.deps.jackson.databind.ObjectMapper;
import io.dekorate.deps.kubernetes.api.model.ConfigMap;
import io.dekorate.deps.kubernetes.api.model.ConfigMapFluent;
import io.dekorate.deps.kubernetes.api.model.DoneableConfigMap;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.client.KubernetesClient;
import io.dekorate.deps.kubernetes.client.dsl.Namespaceable;
import io.dekorate.deps.kubernetes.client.dsl.Replaceable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.dekorate.deps.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import io.dekorate.deps.kubernetes.client.extended.leaderelection.resourcelock.LockException;
import io.dekorate.deps.kubernetes.client.utils.Serialization;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapLock
implements Lock {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigMapLock.class);
    private final String configMapNamespace;
    private final String configMapName;
    private final String identity;
    private final ObjectMapper objectMapper;

    public ConfigMapLock(String configMapNamespace, String configMapName, String identity) {
        this.configMapNamespace = Objects.requireNonNull(configMapNamespace, "configMapNamespace is required");
        this.configMapName = Objects.requireNonNull(configMapName, "configMapName is required");
        this.identity = Objects.requireNonNull(identity, "identity is required");
        this.objectMapper = Serialization.jsonMapper();
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> LeaderElectionRecord get(C client) {
        ConfigMap configMap = (ConfigMap)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).get();
        return Optional.ofNullable(configMap).map(ConfigMap::getMetadata).map(ObjectMeta::getAnnotations).map(annotations -> (String)annotations.get("control-plane.alpha.kubernetes.io/leader")).map(annotation -> {
            try {
                return this.objectMapper.readValue((String)annotation, new TypeReference<LeaderElectionRecord>(){});
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Error deserializing LeaderElectionRecord from ConfigMap", (Throwable)ex);
                return null;
            }
        }).map(record -> {
            record.setVersion((Serializable)((Object)configMap.getMetadata().getResourceVersion()));
            return record;
        }).orElse(null);
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> void create(C client, LeaderElectionRecord leaderElectionRecord) throws LockException {
        try {
            ((DoneableConfigMap)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((DoneableConfigMap)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).createNew()).editOrNewMetadata().withNamespace(this.configMapNamespace)).withName(this.configMapName)).addToAnnotations("control-plane.alpha.kubernetes.io/leader", this.objectMapper.writeValueAsString(leaderElectionRecord))).endMetadata()).done();
        }
        catch (Exception e) {
            throw new LockException("Unable to create ConfigMapLock", e);
        }
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> void update(C client, LeaderElectionRecord leaderElectionRecord) throws LockException {
        try {
            ConfigMap toReplace = (ConfigMap)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).get();
            toReplace.getMetadata().getAnnotations().put("control-plane.alpha.kubernetes.io/leader", this.objectMapper.writeValueAsString(leaderElectionRecord));
            ((Replaceable)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).lockResourceVersion((String)((Object)Objects.requireNonNull(leaderElectionRecord.getVersion())))).replace(toReplace);
        }
        catch (Exception e) {
            throw new LockException("Unable to update ConfigMapLock", e);
        }
    }

    @Override
    public String identity() {
        return this.identity;
    }

    @Override
    public String describe() {
        return String.format("ConfigMapLock: %s - %s (%s)", this.configMapNamespace, this.configMapName, this.identity);
    }
}

