/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.dsl.internal;

import io.dekorate.deps.jackson.databind.ObjectMapper;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.VersionInfo;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationSupport;
import io.dekorate.deps.kubernetes.client.utils.URLUtils;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.okhttp3.Request;
import io.dekorate.deps.okhttp3.Response;
import io.dekorate.deps.openshift.api.model.ClusterVersionList;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class ClusterOperationsImpl
extends OperationSupport {
    private String versionEndpoint;
    public static final String KUBERNETES_VERSION_ENDPOINT = "version";
    public static final String OPENSHIFT_VERSION_ENDPOINT = "version/openshift";
    public static final String OPENSHIFT4_VERSION_ENDPOINT = "apis/config.openshift.io/v1/clusterversions";
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public ClusterOperationsImpl(OkHttpClient client, Config config, String item) {
        super(new OperationContext().withOkhttpClient(client).withConfig(config));
        this.versionEndpoint = item;
    }

    public VersionInfo fetchVersion() {
        try {
            Response response = this.handleVersionGet(this.versionEndpoint);
            if (404 == response.code() && this.versionEndpoint.equals(OPENSHIFT_VERSION_ENDPOINT)) {
                response.close();
                return this.fetchOpenshift4Version();
            }
            Map myMap = objectMapper.readValue(response.body().string(), HashMap.class);
            return this.fetchVersionInfoFromResponse(myMap);
        }
        catch (Exception e) {
            KubernetesClientException.launderThrowable(e);
            return null;
        }
    }

    private Response handleVersionGet(String versionEndpointToBeUsed) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().get().url(URLUtils.join(this.config.getMasterUrl(), versionEndpointToBeUsed));
        return this.client.newCall(requestBuilder.build()).execute();
    }

    private VersionInfo fetchOpenshift4Version() throws IOException, ParseException {
        ClusterVersionList clusterVersionList;
        Response response = this.handleVersionGet(OPENSHIFT4_VERSION_ENDPOINT);
        if (response.isSuccessful() && response.body() != null && !(clusterVersionList = objectMapper.readValue(response.body().string(), ClusterVersionList.class)).getItems().isEmpty()) {
            return VersionInfo.parseVersionInfoFromClusterVersion(clusterVersionList.getItems().get(0));
        }
        return null;
    }

    private VersionInfo fetchVersionInfoFromResponse(Map<String, String> responseAsMap) throws ParseException {
        return new VersionInfo.Builder().withBuildDate(responseAsMap.get("buildDate")).withGitCommit(responseAsMap.get("gitCommit")).withGitVersion(responseAsMap.get("gitVersion")).withMajor(responseAsMap.get("major")).withMinor(responseAsMap.get("minor")).withGitTreeState(responseAsMap.get("gitTreeState")).withPlatform(responseAsMap.get("platform")).withGoVersion(responseAsMap.get("goVersion")).withCompiler(responseAsMap.get("compiler")).build();
    }
}

