/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.applicationcrd.api.model;

import io.dekorate.deps.applicationcrd.api.model.InfoItemSource;
import io.dekorate.deps.applicationcrd.api.model.InfoItemSourceFluent;
import io.dekorate.deps.applicationcrd.api.model.InfoItemSourceFluentImpl;
import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;

public class InfoItemSourceBuilder
extends InfoItemSourceFluentImpl<InfoItemSourceBuilder>
implements VisitableBuilder<InfoItemSource, InfoItemSourceBuilder> {
    InfoItemSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public InfoItemSourceBuilder() {
        this(true);
    }

    public InfoItemSourceBuilder(Boolean validationEnabled) {
        this(new InfoItemSource(), validationEnabled);
    }

    public InfoItemSourceBuilder(InfoItemSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public InfoItemSourceBuilder(InfoItemSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new InfoItemSource(), validationEnabled);
    }

    public InfoItemSourceBuilder(InfoItemSourceFluent<?> fluent, InfoItemSource instance) {
        this(fluent, instance, true);
    }

    public InfoItemSourceBuilder(InfoItemSourceFluent<?> fluent, InfoItemSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        fluent.withIngressRef(instance.getIngressRef());
        fluent.withSecretKeyRef(instance.getSecretKeyRef());
        fluent.withServiceRef(instance.getServiceRef());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public InfoItemSourceBuilder(InfoItemSource instance) {
        this(instance, (Boolean)true);
    }

    public InfoItemSourceBuilder(InfoItemSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        this.withIngressRef(instance.getIngressRef());
        this.withSecretKeyRef(instance.getSecretKeyRef());
        this.withServiceRef(instance.getServiceRef());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public InfoItemSourceBuilder(Validator validator) {
        this(new InfoItemSource(), (Boolean)true);
    }

    public InfoItemSourceBuilder(InfoItemSourceFluent<?> fluent, InfoItemSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        fluent.withIngressRef(instance.getIngressRef());
        fluent.withSecretKeyRef(instance.getSecretKeyRef());
        fluent.withServiceRef(instance.getServiceRef());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public InfoItemSourceBuilder(InfoItemSource instance, Validator validator) {
        this.fluent = this;
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        this.withIngressRef(instance.getIngressRef());
        this.withSecretKeyRef(instance.getSecretKeyRef());
        this.withServiceRef(instance.getServiceRef());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public InfoItemSource build() {
        InfoItemSource buildable = new InfoItemSource(this.fluent.getConfigMapKeyRef(), this.fluent.getIngressRef(), this.fluent.getSecretKeyRef(), this.fluent.getServiceRef(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfoItemSourceBuilder that = (InfoItemSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

