/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.jackson.databind.node;

import io.dekorate.deps.jackson.core.JsonGenerator;
import io.dekorate.deps.jackson.core.JsonParser;
import io.dekorate.deps.jackson.core.JsonProcessingException;
import io.dekorate.deps.jackson.core.JsonToken;
import io.dekorate.deps.jackson.core.ObjectCodec;
import io.dekorate.deps.jackson.databind.JsonNode;
import io.dekorate.deps.jackson.databind.JsonSerializable;
import io.dekorate.deps.jackson.databind.SerializerProvider;
import io.dekorate.deps.jackson.databind.jsontype.TypeSerializer;
import io.dekorate.deps.jackson.databind.node.MissingNode;
import io.dekorate.deps.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;

public abstract class BaseJsonNode
extends JsonNode
implements JsonSerializable {
    protected BaseJsonNode() {
    }

    @Override
    public final JsonNode findPath(String fieldName) {
        JsonNode value = this.findValue(fieldName);
        if (value == null) {
            return MissingNode.getInstance();
        }
        return value;
    }

    public abstract int hashCode();

    @Override
    public JsonParser traverse() {
        return new TreeTraversingParser(this);
    }

    @Override
    public JsonParser traverse(ObjectCodec codec) {
        return new TreeTraversingParser(this, codec);
    }

    @Override
    public abstract JsonToken asToken();

    @Override
    public JsonParser.NumberType numberType() {
        return null;
    }

    @Override
    public abstract void serialize(JsonGenerator var1, SerializerProvider var2) throws IOException, JsonProcessingException;

    @Override
    public abstract void serializeWithType(JsonGenerator var1, SerializerProvider var2, TypeSerializer var3) throws IOException, JsonProcessingException;
}

