/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Affinity;
import io.dekorate.deps.kubernetes.api.model.AffinityFluent;
import io.dekorate.deps.kubernetes.api.model.AffinityFluentImpl;

public class AffinityBuilder
extends AffinityFluentImpl<AffinityBuilder>
implements VisitableBuilder<Affinity, AffinityBuilder> {
    AffinityFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AffinityBuilder() {
        this(true);
    }

    public AffinityBuilder(Boolean validationEnabled) {
        this(new Affinity(), validationEnabled);
    }

    public AffinityBuilder(AffinityFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Affinity(), validationEnabled);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Affinity instance) {
        this(fluent, instance, true);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Affinity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNodeAffinity(instance.getNodeAffinity());
        fluent.withPodAffinity(instance.getPodAffinity());
        fluent.withPodAntiAffinity(instance.getPodAntiAffinity());
        this.validationEnabled = validationEnabled;
    }

    public AffinityBuilder(Affinity instance) {
        this(instance, (Boolean)true);
    }

    public AffinityBuilder(Affinity instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNodeAffinity(instance.getNodeAffinity());
        this.withPodAffinity(instance.getPodAffinity());
        this.withPodAntiAffinity(instance.getPodAntiAffinity());
        this.validationEnabled = validationEnabled;
    }

    public AffinityBuilder(Validator validator) {
        this(new Affinity(), (Boolean)true);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Affinity instance, Validator validator) {
        this.fluent = fluent;
        fluent.withNodeAffinity(instance.getNodeAffinity());
        fluent.withPodAffinity(instance.getPodAffinity());
        fluent.withPodAntiAffinity(instance.getPodAntiAffinity());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public AffinityBuilder(Affinity instance, Validator validator) {
        this.fluent = this;
        this.withNodeAffinity(instance.getNodeAffinity());
        this.withPodAffinity(instance.getPodAffinity());
        this.withPodAntiAffinity(instance.getPodAntiAffinity());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Affinity build() {
        Affinity buildable = new Affinity(this.fluent.getNodeAffinity(), this.fluent.getPodAffinity(), this.fluent.getPodAntiAffinity());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AffinityBuilder that = (AffinityBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

