/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Binding;
import io.dekorate.deps.kubernetes.api.model.BindingFluent;
import io.dekorate.deps.kubernetes.api.model.BindingFluentImpl;

public class BindingBuilder
extends BindingFluentImpl<BindingBuilder>
implements VisitableBuilder<Binding, BindingBuilder> {
    BindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BindingBuilder() {
        this(true);
    }

    public BindingBuilder(Boolean validationEnabled) {
        this(new Binding(), validationEnabled);
    }

    public BindingBuilder(BindingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BindingBuilder(BindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Binding(), validationEnabled);
    }

    public BindingBuilder(BindingFluent<?> fluent, Binding instance) {
        this(fluent, instance, true);
    }

    public BindingBuilder(BindingFluent<?> fluent, Binding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withTarget(instance.getTarget());
        this.validationEnabled = validationEnabled;
    }

    public BindingBuilder(Binding instance) {
        this(instance, (Boolean)true);
    }

    public BindingBuilder(Binding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTarget(instance.getTarget());
        this.validationEnabled = validationEnabled;
    }

    public BindingBuilder(Validator validator) {
        this(new Binding(), (Boolean)true);
    }

    public BindingBuilder(BindingFluent<?> fluent, Binding instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withTarget(instance.getTarget());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BindingBuilder(Binding instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTarget(instance.getTarget());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Binding build() {
        Binding buildable = new Binding(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getTarget());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BindingBuilder that = (BindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

