/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.ConfigMapNodeConfigSource;
import io.dekorate.deps.kubernetes.api.model.ConfigMapNodeConfigSourceFluent;
import io.dekorate.deps.kubernetes.api.model.ConfigMapNodeConfigSourceFluentImpl;

public class ConfigMapNodeConfigSourceBuilder
extends ConfigMapNodeConfigSourceFluentImpl<ConfigMapNodeConfigSourceBuilder>
implements VisitableBuilder<ConfigMapNodeConfigSource, ConfigMapNodeConfigSourceBuilder> {
    ConfigMapNodeConfigSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ConfigMapNodeConfigSourceBuilder() {
        this(true);
    }

    public ConfigMapNodeConfigSourceBuilder(Boolean validationEnabled) {
        this(new ConfigMapNodeConfigSource(), validationEnabled);
    }

    public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConfigMapNodeConfigSource(), validationEnabled);
    }

    public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSourceFluent<?> fluent, ConfigMapNodeConfigSource instance) {
        this(fluent, instance, true);
    }

    public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSourceFluent<?> fluent, ConfigMapNodeConfigSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withKubeletConfigKey(instance.getKubeletConfigKey());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSource instance) {
        this(instance, (Boolean)true);
    }

    public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withKubeletConfigKey(instance.getKubeletConfigKey());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResourceVersion(instance.getResourceVersion());
        this.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public ConfigMapNodeConfigSourceBuilder(Validator validator) {
        this(new ConfigMapNodeConfigSource(), (Boolean)true);
    }

    public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSourceFluent<?> fluent, ConfigMapNodeConfigSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withKubeletConfigKey(instance.getKubeletConfigKey());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withUid(instance.getUid());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSource instance, Validator validator) {
        this.fluent = this;
        this.withKubeletConfigKey(instance.getKubeletConfigKey());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResourceVersion(instance.getResourceVersion());
        this.withUid(instance.getUid());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ConfigMapNodeConfigSource build() {
        ConfigMapNodeConfigSource buildable = new ConfigMapNodeConfigSource(this.fluent.getKubeletConfigKey(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getResourceVersion(), this.fluent.getUid());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapNodeConfigSourceBuilder that = (ConfigMapNodeConfigSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

