/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.HTTPGetAction;
import io.dekorate.deps.kubernetes.api.model.HTTPGetActionFluent;
import io.dekorate.deps.kubernetes.api.model.HTTPGetActionFluentImpl;

public class HTTPGetActionBuilder
extends HTTPGetActionFluentImpl<HTTPGetActionBuilder>
implements VisitableBuilder<HTTPGetAction, HTTPGetActionBuilder> {
    HTTPGetActionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPGetActionBuilder() {
        this(true);
    }

    public HTTPGetActionBuilder(Boolean validationEnabled) {
        this(new HTTPGetAction(), validationEnabled);
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPGetAction(), validationEnabled);
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent, HTTPGetAction instance) {
        this(fluent, instance, true);
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent, HTTPGetAction instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withHttpHeaders(instance.getHttpHeaders());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
        fluent.withScheme(instance.getScheme());
        this.validationEnabled = validationEnabled;
    }

    public HTTPGetActionBuilder(HTTPGetAction instance) {
        this(instance, (Boolean)true);
    }

    public HTTPGetActionBuilder(HTTPGetAction instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withHttpHeaders(instance.getHttpHeaders());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withScheme(instance.getScheme());
        this.validationEnabled = validationEnabled;
    }

    public HTTPGetActionBuilder(Validator validator) {
        this(new HTTPGetAction(), (Boolean)true);
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent, HTTPGetAction instance, Validator validator) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withHttpHeaders(instance.getHttpHeaders());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
        fluent.withScheme(instance.getScheme());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public HTTPGetActionBuilder(HTTPGetAction instance, Validator validator) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withHttpHeaders(instance.getHttpHeaders());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withScheme(instance.getScheme());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public HTTPGetAction build() {
        HTTPGetAction buildable = new HTTPGetAction(this.fluent.getHost(), this.fluent.getHttpHeaders(), this.fluent.getPath(), this.fluent.getPort(), this.fluent.getScheme());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPGetActionBuilder that = (HTTPGetActionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

