/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Handler;
import io.dekorate.deps.kubernetes.api.model.HandlerFluent;
import io.dekorate.deps.kubernetes.api.model.HandlerFluentImpl;

public class HandlerBuilder
extends HandlerFluentImpl<HandlerBuilder>
implements VisitableBuilder<Handler, HandlerBuilder> {
    HandlerFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HandlerBuilder() {
        this(true);
    }

    public HandlerBuilder(Boolean validationEnabled) {
        this(new Handler(), validationEnabled);
    }

    public HandlerBuilder(HandlerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HandlerBuilder(HandlerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Handler(), validationEnabled);
    }

    public HandlerBuilder(HandlerFluent<?> fluent, Handler instance) {
        this(fluent, instance, true);
    }

    public HandlerBuilder(HandlerFluent<?> fluent, Handler instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withTcpSocket(instance.getTcpSocket());
        this.validationEnabled = validationEnabled;
    }

    public HandlerBuilder(Handler instance) {
        this(instance, (Boolean)true);
    }

    public HandlerBuilder(Handler instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withHttpGet(instance.getHttpGet());
        this.withTcpSocket(instance.getTcpSocket());
        this.validationEnabled = validationEnabled;
    }

    public HandlerBuilder(Validator validator) {
        this(new Handler(), (Boolean)true);
    }

    public HandlerBuilder(HandlerFluent<?> fluent, Handler instance, Validator validator) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withTcpSocket(instance.getTcpSocket());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public HandlerBuilder(Handler instance, Validator validator) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withHttpGet(instance.getHttpGet());
        this.withTcpSocket(instance.getTcpSocket());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Handler build() {
        Handler buildable = new Handler(this.fluent.getExec(), this.fluent.getHttpGet(), this.fluent.getTcpSocket());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HandlerBuilder that = (HandlerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

