/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Initializers;
import io.dekorate.deps.kubernetes.api.model.InitializersFluent;
import io.dekorate.deps.kubernetes.api.model.InitializersFluentImpl;

public class InitializersBuilder
extends InitializersFluentImpl<InitializersBuilder>
implements VisitableBuilder<Initializers, InitializersBuilder> {
    InitializersFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public InitializersBuilder() {
        this(true);
    }

    public InitializersBuilder(Boolean validationEnabled) {
        this(new Initializers(), validationEnabled);
    }

    public InitializersBuilder(InitializersFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public InitializersBuilder(InitializersFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Initializers(), validationEnabled);
    }

    public InitializersBuilder(InitializersFluent<?> fluent, Initializers instance) {
        this(fluent, instance, true);
    }

    public InitializersBuilder(InitializersFluent<?> fluent, Initializers instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPending(instance.getPending());
        fluent.withResult(instance.getResult());
        this.validationEnabled = validationEnabled;
    }

    public InitializersBuilder(Initializers instance) {
        this(instance, (Boolean)true);
    }

    public InitializersBuilder(Initializers instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPending(instance.getPending());
        this.withResult(instance.getResult());
        this.validationEnabled = validationEnabled;
    }

    public InitializersBuilder(Validator validator) {
        this(new Initializers(), (Boolean)true);
    }

    public InitializersBuilder(InitializersFluent<?> fluent, Initializers instance, Validator validator) {
        this.fluent = fluent;
        fluent.withPending(instance.getPending());
        fluent.withResult(instance.getResult());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public InitializersBuilder(Initializers instance, Validator validator) {
        this.fluent = this;
        this.withPending(instance.getPending());
        this.withResult(instance.getResult());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Initializers build() {
        Initializers buildable = new Initializers(this.fluent.getPending(), this.fluent.getResult());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InitializersBuilder that = (InitializersBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

