/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.deps.kubernetes.api.model.KubernetesListFluent;
import io.dekorate.deps.kubernetes.api.model.KubernetesListFluentImpl;

public class KubernetesListBuilder
extends KubernetesListFluentImpl<KubernetesListBuilder>
implements VisitableBuilder<KubernetesList, KubernetesListBuilder> {
    KubernetesListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesListBuilder() {
        this(true);
    }

    public KubernetesListBuilder(Boolean validationEnabled) {
        this(new KubernetesList(), validationEnabled);
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesList(), validationEnabled);
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent, KubernetesList instance) {
        this(fluent, instance, true);
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent, KubernetesList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesListBuilder(KubernetesList instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesListBuilder(KubernetesList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesListBuilder(Validator validator) {
        this(new KubernetesList(), (Boolean)true);
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent, KubernetesList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public KubernetesListBuilder(KubernetesList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public KubernetesList build() {
        KubernetesList buildable = new KubernetesList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesListBuilder that = (KubernetesListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

