/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.LabelSelector;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorFluent;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorFluentImpl;

public class LabelSelectorBuilder
extends LabelSelectorFluentImpl<LabelSelectorBuilder>
implements VisitableBuilder<LabelSelector, LabelSelectorBuilder> {
    LabelSelectorFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public LabelSelectorBuilder() {
        this(true);
    }

    public LabelSelectorBuilder(Boolean validationEnabled) {
        this(new LabelSelector(), validationEnabled);
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LabelSelector(), validationEnabled);
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent, LabelSelector instance) {
        this(fluent, instance, true);
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent, LabelSelector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMatchExpressions(instance.getMatchExpressions());
        fluent.withMatchLabels(instance.getMatchLabels());
        this.validationEnabled = validationEnabled;
    }

    public LabelSelectorBuilder(LabelSelector instance) {
        this(instance, (Boolean)true);
    }

    public LabelSelectorBuilder(LabelSelector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMatchExpressions(instance.getMatchExpressions());
        this.withMatchLabels(instance.getMatchLabels());
        this.validationEnabled = validationEnabled;
    }

    public LabelSelectorBuilder(Validator validator) {
        this(new LabelSelector(), (Boolean)true);
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent, LabelSelector instance, Validator validator) {
        this.fluent = fluent;
        fluent.withMatchExpressions(instance.getMatchExpressions());
        fluent.withMatchLabels(instance.getMatchLabels());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public LabelSelectorBuilder(LabelSelector instance, Validator validator) {
        this.fluent = this;
        this.withMatchExpressions(instance.getMatchExpressions());
        this.withMatchLabels(instance.getMatchLabels());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public LabelSelector build() {
        LabelSelector buildable = new LabelSelector(this.fluent.getMatchExpressions(), this.fluent.getMatchLabels());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelectorBuilder that = (LabelSelectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

