/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.LoadBalancerStatus;
import io.dekorate.deps.kubernetes.api.model.LoadBalancerStatusFluent;
import io.dekorate.deps.kubernetes.api.model.LoadBalancerStatusFluentImpl;

public class LoadBalancerStatusBuilder
extends LoadBalancerStatusFluentImpl<LoadBalancerStatusBuilder>
implements VisitableBuilder<LoadBalancerStatus, LoadBalancerStatusBuilder> {
    LoadBalancerStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public LoadBalancerStatusBuilder() {
        this(true);
    }

    public LoadBalancerStatusBuilder(Boolean validationEnabled) {
        this(new LoadBalancerStatus(), validationEnabled);
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LoadBalancerStatus(), validationEnabled);
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent, LoadBalancerStatus instance) {
        this(fluent, instance, true);
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent, LoadBalancerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIngress(instance.getIngress());
        this.validationEnabled = validationEnabled;
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatus instance) {
        this(instance, (Boolean)true);
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIngress(instance.getIngress());
        this.validationEnabled = validationEnabled;
    }

    public LoadBalancerStatusBuilder(Validator validator) {
        this(new LoadBalancerStatus(), (Boolean)true);
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent, LoadBalancerStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withIngress(instance.getIngress());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatus instance, Validator validator) {
        this.fluent = this;
        this.withIngress(instance.getIngress());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public LoadBalancerStatus build() {
        LoadBalancerStatus buildable = new LoadBalancerStatus(this.fluent.getIngress());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerStatusBuilder that = (LoadBalancerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

