/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Node;
import io.dekorate.deps.kubernetes.api.model.NodeFluent;
import io.dekorate.deps.kubernetes.api.model.NodeFluentImpl;

public class NodeBuilder
extends NodeFluentImpl<NodeBuilder>
implements VisitableBuilder<Node, NodeBuilder> {
    NodeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NodeBuilder() {
        this(true);
    }

    public NodeBuilder(Boolean validationEnabled) {
        this(new Node(), validationEnabled);
    }

    public NodeBuilder(NodeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeBuilder(NodeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Node(), validationEnabled);
    }

    public NodeBuilder(NodeFluent<?> fluent, Node instance) {
        this(fluent, instance, true);
    }

    public NodeBuilder(NodeFluent<?> fluent, Node instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public NodeBuilder(Node instance) {
        this(instance, (Boolean)true);
    }

    public NodeBuilder(Node instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public NodeBuilder(Validator validator) {
        this(new Node(), (Boolean)true);
    }

    public NodeBuilder(NodeFluent<?> fluent, Node instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NodeBuilder(Node instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Node build() {
        Node buildable = new Node(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeBuilder that = (NodeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

