/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.model.NodeConfigSource;
import io.dekorate.deps.kubernetes.api.model.NodeConfigSourceBuilder;
import io.dekorate.deps.kubernetes.api.model.NodeConfigSourceFluentImpl;
import io.dekorate.deps.kubernetes.api.model.NodeSpec;
import io.dekorate.deps.kubernetes.api.model.NodeSpecFluent;
import io.dekorate.deps.kubernetes.api.model.Taint;
import io.dekorate.deps.kubernetes.api.model.TaintBuilder;
import io.dekorate.deps.kubernetes.api.model.TaintFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeSpecFluentImpl<A extends NodeSpecFluent<A>>
extends BaseFluent<A>
implements NodeSpecFluent<A> {
    private NodeConfigSourceBuilder configSource;
    private String externalID;
    private String podCIDR;
    private String providerID;
    private List<TaintBuilder> taints;
    private Boolean unschedulable;

    public NodeSpecFluentImpl() {
    }

    public NodeSpecFluentImpl(NodeSpec instance) {
        this.withConfigSource(instance.getConfigSource());
        this.withExternalID(instance.getExternalID());
        this.withPodCIDR(instance.getPodCIDR());
        this.withProviderID(instance.getProviderID());
        this.withTaints(instance.getTaints());
        this.withUnschedulable(instance.getUnschedulable());
    }

    @Override
    @Deprecated
    public NodeConfigSource getConfigSource() {
        return this.configSource != null ? this.configSource.build() : null;
    }

    @Override
    public NodeConfigSource buildConfigSource() {
        return this.configSource != null ? this.configSource.build() : null;
    }

    @Override
    public A withConfigSource(NodeConfigSource configSource) {
        this._visitables.get("configSource").remove(this.configSource);
        if (configSource != null) {
            this.configSource = new NodeConfigSourceBuilder(configSource);
            this._visitables.get("configSource").add(this.configSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigSource() {
        return this.configSource != null;
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> withNewConfigSource() {
        return new ConfigSourceNestedImpl();
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> withNewConfigSourceLike(NodeConfigSource item) {
        return new ConfigSourceNestedImpl(item);
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> editConfigSource() {
        return this.withNewConfigSourceLike(this.getConfigSource());
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSource() {
        return this.withNewConfigSourceLike(this.getConfigSource() != null ? this.getConfigSource() : new NodeConfigSourceBuilder().build());
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSourceLike(NodeConfigSource item) {
        return this.withNewConfigSourceLike(this.getConfigSource() != null ? this.getConfigSource() : item);
    }

    @Override
    public String getExternalID() {
        return this.externalID;
    }

    @Override
    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)this;
    }

    @Override
    public Boolean hasExternalID() {
        return this.externalID != null;
    }

    @Override
    public A withNewExternalID(String arg1) {
        return this.withExternalID(new String(arg1));
    }

    @Override
    public A withNewExternalID(StringBuilder arg1) {
        return this.withExternalID(new String(arg1));
    }

    @Override
    public A withNewExternalID(StringBuffer arg1) {
        return this.withExternalID(new String(arg1));
    }

    @Override
    public String getPodCIDR() {
        return this.podCIDR;
    }

    @Override
    public A withPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
        return (A)this;
    }

    @Override
    public Boolean hasPodCIDR() {
        return this.podCIDR != null;
    }

    @Override
    public A withNewPodCIDR(String arg1) {
        return this.withPodCIDR(new String(arg1));
    }

    @Override
    public A withNewPodCIDR(StringBuilder arg1) {
        return this.withPodCIDR(new String(arg1));
    }

    @Override
    public A withNewPodCIDR(StringBuffer arg1) {
        return this.withPodCIDR(new String(arg1));
    }

    @Override
    public String getProviderID() {
        return this.providerID;
    }

    @Override
    public A withProviderID(String providerID) {
        this.providerID = providerID;
        return (A)this;
    }

    @Override
    public Boolean hasProviderID() {
        return this.providerID != null;
    }

    @Override
    public A withNewProviderID(String arg1) {
        return this.withProviderID(new String(arg1));
    }

    @Override
    public A withNewProviderID(StringBuilder arg1) {
        return this.withProviderID(new String(arg1));
    }

    @Override
    public A withNewProviderID(StringBuffer arg1) {
        return this.withProviderID(new String(arg1));
    }

    @Override
    public A addToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<TaintBuilder>();
        }
        TaintBuilder builder = new TaintBuilder(item);
        this._visitables.get("taints").add(index >= 0 ? index : this._visitables.get("taints").size(), builder);
        this.taints.add(index >= 0 ? index : this.taints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<TaintBuilder>();
        }
        TaintBuilder builder = new TaintBuilder(item);
        if (index < 0 || index >= this._visitables.get("taints").size()) {
            this._visitables.get("taints").add(builder);
        } else {
            this._visitables.get("taints").set(index, builder);
        }
        if (index < 0 || index >= this.taints.size()) {
            this.taints.add(builder);
        } else {
            this.taints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTaints(Taint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList<TaintBuilder>();
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTaints(Collection<Taint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList<TaintBuilder>();
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaints(Taint ... items) {
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            if (this.taints == null) continue;
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTaints(Collection<Taint> items) {
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            if (this.taints == null) continue;
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Taint> getTaints() {
        return NodeSpecFluentImpl.build(this.taints);
    }

    @Override
    public List<Taint> buildTaints() {
        return NodeSpecFluentImpl.build(this.taints);
    }

    @Override
    public Taint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    @Override
    public Taint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    @Override
    public Taint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    @Override
    public Taint buildMatchingTaint(Predicate<TaintBuilder> predicate) {
        for (TaintBuilder item : this.taints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTaint(Predicate<TaintBuilder> predicate) {
        for (TaintBuilder item : this.taints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTaints(List<Taint> taints) {
        if (this.taints != null) {
            this._visitables.get("taints").removeAll(this.taints);
        }
        if (taints != null) {
            this.taints = new ArrayList<TaintBuilder>();
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = new ArrayList<TaintBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withTaints(Taint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
        }
        if (taints != null) {
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    @Override
    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new Taint(effect, key, timeAdded, value));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> addNewTaint() {
        return new TaintsNestedImpl();
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> addNewTaintLike(Taint item) {
        return new TaintsNestedImpl(-1, item);
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> setNewTaintLike(int index, Taint item) {
        return new TaintsNestedImpl(index, item);
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException("Can't edit taints. Index exceeds size.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException("Can't edit first taints. The list is empty.");
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last taints. The list is empty.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editMatchingTaint(Predicate<TaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.apply(this.taints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching taints. No match found.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public Boolean isUnschedulable() {
        return this.unschedulable;
    }

    @Override
    public A withUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
        return (A)this;
    }

    @Override
    public Boolean hasUnschedulable() {
        return this.unschedulable != null;
    }

    @Override
    public A withNewUnschedulable(String arg1) {
        return this.withUnschedulable(new Boolean(arg1));
    }

    @Override
    public A withNewUnschedulable(boolean arg1) {
        return this.withUnschedulable(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSpecFluentImpl that = (NodeSpecFluentImpl)o;
        if (this.configSource != null ? !this.configSource.equals(that.configSource) : that.configSource != null) {
            return false;
        }
        if (this.externalID != null ? !this.externalID.equals(that.externalID) : that.externalID != null) {
            return false;
        }
        if (this.podCIDR != null ? !this.podCIDR.equals(that.podCIDR) : that.podCIDR != null) {
            return false;
        }
        if (this.providerID != null ? !this.providerID.equals(that.providerID) : that.providerID != null) {
            return false;
        }
        if (this.taints != null ? !this.taints.equals(that.taints) : that.taints != null) {
            return false;
        }
        return !(this.unschedulable != null ? !this.unschedulable.equals(that.unschedulable) : that.unschedulable != null);
    }

    public class TaintsNestedImpl<N>
    extends TaintFluentImpl<NodeSpecFluent.TaintsNested<N>>
    implements NodeSpecFluent.TaintsNested<N>,
    Nested<N> {
        private final TaintBuilder builder;
        private final int index;

        TaintsNestedImpl(int index, Taint item) {
            this.index = index;
            this.builder = new TaintBuilder(this, item);
        }

        TaintsNestedImpl() {
            this.index = -1;
            this.builder = new TaintBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeSpecFluentImpl.this.setToTaints(this.index, this.builder.build());
        }

        @Override
        public N endTaint() {
            return this.and();
        }
    }

    public class ConfigSourceNestedImpl<N>
    extends NodeConfigSourceFluentImpl<NodeSpecFluent.ConfigSourceNested<N>>
    implements NodeSpecFluent.ConfigSourceNested<N>,
    Nested<N> {
        private final NodeConfigSourceBuilder builder;

        ConfigSourceNestedImpl(NodeConfigSource item) {
            this.builder = new NodeConfigSourceBuilder(this, item);
        }

        ConfigSourceNestedImpl() {
            this.builder = new NodeConfigSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeSpecFluentImpl.this.withConfigSource(this.builder.build());
        }

        @Override
        public N endConfigSource() {
            return this.and();
        }
    }
}

