/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Pod;
import io.dekorate.deps.kubernetes.api.model.PodFluent;
import io.dekorate.deps.kubernetes.api.model.PodFluentImpl;

public class PodBuilder
extends PodFluentImpl<PodBuilder>
implements VisitableBuilder<Pod, PodBuilder> {
    PodFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PodBuilder() {
        this(true);
    }

    public PodBuilder(Boolean validationEnabled) {
        this(new Pod(), validationEnabled);
    }

    public PodBuilder(PodFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodBuilder(PodFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Pod(), validationEnabled);
    }

    public PodBuilder(PodFluent<?> fluent, Pod instance) {
        this(fluent, instance, true);
    }

    public PodBuilder(PodFluent<?> fluent, Pod instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public PodBuilder(Pod instance) {
        this(instance, (Boolean)true);
    }

    public PodBuilder(Pod instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public PodBuilder(Validator validator) {
        this(new Pod(), (Boolean)true);
    }

    public PodBuilder(PodFluent<?> fluent, Pod instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PodBuilder(Pod instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Pod build() {
        Pod buildable = new Pod(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodBuilder that = (PodBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

