/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSecurityContext;
import io.dekorate.deps.kubernetes.api.model.PodSecurityContextFluent;
import io.dekorate.deps.kubernetes.api.model.PodSecurityContextFluentImpl;

public class PodSecurityContextBuilder
extends PodSecurityContextFluentImpl<PodSecurityContextBuilder>
implements VisitableBuilder<PodSecurityContext, PodSecurityContextBuilder> {
    PodSecurityContextFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PodSecurityContextBuilder() {
        this(true);
    }

    public PodSecurityContextBuilder(Boolean validationEnabled) {
        this(new PodSecurityContext(), validationEnabled);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodSecurityContext(), validationEnabled);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, PodSecurityContext instance) {
        this(fluent, instance, true);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, PodSecurityContext instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFsGroup(instance.getFsGroup());
        fluent.withRunAsGroup(instance.getRunAsGroup());
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
        fluent.withSupplementalGroups(instance.getSupplementalGroups());
        fluent.withSysctls(instance.getSysctls());
        this.validationEnabled = validationEnabled;
    }

    public PodSecurityContextBuilder(PodSecurityContext instance) {
        this(instance, (Boolean)true);
    }

    public PodSecurityContextBuilder(PodSecurityContext instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFsGroup(instance.getFsGroup());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withSysctls(instance.getSysctls());
        this.validationEnabled = validationEnabled;
    }

    public PodSecurityContextBuilder(Validator validator) {
        this(new PodSecurityContext(), (Boolean)true);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, PodSecurityContext instance, Validator validator) {
        this.fluent = fluent;
        fluent.withFsGroup(instance.getFsGroup());
        fluent.withRunAsGroup(instance.getRunAsGroup());
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
        fluent.withSupplementalGroups(instance.getSupplementalGroups());
        fluent.withSysctls(instance.getSysctls());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PodSecurityContextBuilder(PodSecurityContext instance, Validator validator) {
        this.fluent = this;
        this.withFsGroup(instance.getFsGroup());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withSysctls(instance.getSysctls());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PodSecurityContext build() {
        PodSecurityContext buildable = new PodSecurityContext(this.fluent.getFsGroup(), this.fluent.getRunAsGroup(), this.fluent.isRunAsNonRoot(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxOptions(), this.fluent.getSupplementalGroups(), this.fluent.getSysctls());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityContextBuilder that = (PodSecurityContextBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

