/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Probe;
import io.dekorate.deps.kubernetes.api.model.ProbeFluent;
import io.dekorate.deps.kubernetes.api.model.ProbeFluentImpl;

public class ProbeBuilder
extends ProbeFluentImpl<ProbeBuilder>
implements VisitableBuilder<Probe, ProbeBuilder> {
    ProbeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ProbeBuilder() {
        this(true);
    }

    public ProbeBuilder(Boolean validationEnabled) {
        this(new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance) {
        this(fluent, instance, true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withFailureThreshold(instance.getFailureThreshold());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        fluent.withPeriodSeconds(instance.getPeriodSeconds());
        fluent.withSuccessThreshold(instance.getSuccessThreshold());
        fluent.withTcpSocket(instance.getTcpSocket());
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    public ProbeBuilder(Probe instance) {
        this(instance, (Boolean)true);
    }

    public ProbeBuilder(Probe instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withFailureThreshold(instance.getFailureThreshold());
        this.withHttpGet(instance.getHttpGet());
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        this.withPeriodSeconds(instance.getPeriodSeconds());
        this.withSuccessThreshold(instance.getSuccessThreshold());
        this.withTcpSocket(instance.getTcpSocket());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    public ProbeBuilder(Validator validator) {
        this(new Probe(), (Boolean)true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance, Validator validator) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withFailureThreshold(instance.getFailureThreshold());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        fluent.withPeriodSeconds(instance.getPeriodSeconds());
        fluent.withSuccessThreshold(instance.getSuccessThreshold());
        fluent.withTcpSocket(instance.getTcpSocket());
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ProbeBuilder(Probe instance, Validator validator) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withFailureThreshold(instance.getFailureThreshold());
        this.withHttpGet(instance.getHttpGet());
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        this.withPeriodSeconds(instance.getPeriodSeconds());
        this.withSuccessThreshold(instance.getSuccessThreshold());
        this.withTcpSocket(instance.getTcpSocket());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Probe build() {
        Probe buildable = new Probe(this.fluent.getExec(), this.fluent.getFailureThreshold(), this.fluent.getHttpGet(), this.fluent.getInitialDelaySeconds(), this.fluent.getPeriodSeconds(), this.fluent.getSuccessThreshold(), this.fluent.getTcpSocket(), this.fluent.getTimeoutSeconds());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeBuilder that = (ProbeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

