/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.ResourceQuota;
import io.dekorate.deps.kubernetes.api.model.ResourceQuotaFluent;
import io.dekorate.deps.kubernetes.api.model.ResourceQuotaFluentImpl;

public class ResourceQuotaBuilder
extends ResourceQuotaFluentImpl<ResourceQuotaBuilder>
implements VisitableBuilder<ResourceQuota, ResourceQuotaBuilder> {
    ResourceQuotaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ResourceQuotaBuilder() {
        this(true);
    }

    public ResourceQuotaBuilder(Boolean validationEnabled) {
        this(new ResourceQuota(), validationEnabled);
    }

    public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceQuota(), validationEnabled);
    }

    public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent, ResourceQuota instance) {
        this(fluent, instance, true);
    }

    public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent, ResourceQuota instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ResourceQuotaBuilder(ResourceQuota instance) {
        this(instance, (Boolean)true);
    }

    public ResourceQuotaBuilder(ResourceQuota instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ResourceQuotaBuilder(Validator validator) {
        this(new ResourceQuota(), (Boolean)true);
    }

    public ResourceQuotaBuilder(ResourceQuotaFluent<?> fluent, ResourceQuota instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ResourceQuotaBuilder(ResourceQuota instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ResourceQuota build() {
        ResourceQuota buildable = new ResourceQuota(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaBuilder that = (ResourceQuotaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

