/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.ResourceQuotaList;
import io.dekorate.deps.kubernetes.api.model.ResourceQuotaListFluent;
import io.dekorate.deps.kubernetes.api.model.ResourceQuotaListFluentImpl;

public class ResourceQuotaListBuilder
extends ResourceQuotaListFluentImpl<ResourceQuotaListBuilder>
implements VisitableBuilder<ResourceQuotaList, ResourceQuotaListBuilder> {
    ResourceQuotaListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ResourceQuotaListBuilder() {
        this(true);
    }

    public ResourceQuotaListBuilder(Boolean validationEnabled) {
        this(new ResourceQuotaList(), validationEnabled);
    }

    public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceQuotaList(), validationEnabled);
    }

    public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent, ResourceQuotaList instance) {
        this(fluent, instance, true);
    }

    public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent, ResourceQuotaList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ResourceQuotaListBuilder(ResourceQuotaList instance) {
        this(instance, (Boolean)true);
    }

    public ResourceQuotaListBuilder(ResourceQuotaList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ResourceQuotaListBuilder(Validator validator) {
        this(new ResourceQuotaList(), (Boolean)true);
    }

    public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent, ResourceQuotaList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ResourceQuotaListBuilder(ResourceQuotaList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ResourceQuotaList build() {
        ResourceQuotaList buildable = new ResourceQuotaList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaListBuilder that = (ResourceQuotaListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

