/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Secret;
import io.dekorate.deps.kubernetes.api.model.SecretFluent;
import io.dekorate.deps.kubernetes.api.model.SecretFluentImpl;

public class SecretBuilder
extends SecretFluentImpl<SecretBuilder>
implements VisitableBuilder<Secret, SecretBuilder> {
    SecretFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SecretBuilder() {
        this(true);
    }

    public SecretBuilder(Boolean validationEnabled) {
        this(new Secret(), validationEnabled);
    }

    public SecretBuilder(SecretFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecretBuilder(SecretFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Secret(), validationEnabled);
    }

    public SecretBuilder(SecretFluent<?> fluent, Secret instance) {
        this(fluent, instance, true);
    }

    public SecretBuilder(SecretFluent<?> fluent, Secret instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withData(instance.getData());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withStringData(instance.getStringData());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public SecretBuilder(Secret instance) {
        this(instance, (Boolean)true);
    }

    public SecretBuilder(Secret instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withStringData(instance.getStringData());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public SecretBuilder(Validator validator) {
        this(new Secret(), (Boolean)true);
    }

    public SecretBuilder(SecretFluent<?> fluent, Secret instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withData(instance.getData());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withStringData(instance.getStringData());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SecretBuilder(Secret instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withStringData(instance.getStringData());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Secret build() {
        Secret buildable = new Secret(this.fluent.getApiVersion(), this.fluent.getData(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getStringData(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretBuilder that = (SecretBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

