/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.ServicePort;
import io.dekorate.deps.kubernetes.api.model.ServicePortFluent;
import io.dekorate.deps.kubernetes.api.model.ServicePortFluentImpl;

public class ServicePortBuilder
extends ServicePortFluentImpl<ServicePortBuilder>
implements VisitableBuilder<ServicePort, ServicePortBuilder> {
    ServicePortFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServicePortBuilder() {
        this(true);
    }

    public ServicePortBuilder(Boolean validationEnabled) {
        this(new ServicePort(), validationEnabled);
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServicePort(), validationEnabled);
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent, ServicePort instance) {
        this(fluent, instance, true);
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent, ServicePort instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNodePort(instance.getNodePort());
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
        fluent.withTargetPort(instance.getTargetPort());
        this.validationEnabled = validationEnabled;
    }

    public ServicePortBuilder(ServicePort instance) {
        this(instance, (Boolean)true);
    }

    public ServicePortBuilder(ServicePort instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNodePort(instance.getNodePort());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.withTargetPort(instance.getTargetPort());
        this.validationEnabled = validationEnabled;
    }

    public ServicePortBuilder(Validator validator) {
        this(new ServicePort(), (Boolean)true);
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent, ServicePort instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNodePort(instance.getNodePort());
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
        fluent.withTargetPort(instance.getTargetPort());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServicePortBuilder(ServicePort instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNodePort(instance.getNodePort());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.withTargetPort(instance.getTargetPort());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ServicePort build() {
        ServicePort buildable = new ServicePort(this.fluent.getName(), this.fluent.getNodePort(), this.fluent.getPort(), this.fluent.getProtocol(), this.fluent.getTargetPort());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServicePortBuilder that = (ServicePortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

