/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Sysctl;
import io.dekorate.deps.kubernetes.api.model.SysctlFluent;
import io.dekorate.deps.kubernetes.api.model.SysctlFluentImpl;

public class SysctlBuilder
extends SysctlFluentImpl<SysctlBuilder>
implements VisitableBuilder<Sysctl, SysctlBuilder> {
    SysctlFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SysctlBuilder() {
        this(true);
    }

    public SysctlBuilder(Boolean validationEnabled) {
        this(new Sysctl(), validationEnabled);
    }

    public SysctlBuilder(SysctlFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SysctlBuilder(SysctlFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Sysctl(), validationEnabled);
    }

    public SysctlBuilder(SysctlFluent<?> fluent, Sysctl instance) {
        this(fluent, instance, true);
    }

    public SysctlBuilder(SysctlFluent<?> fluent, Sysctl instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public SysctlBuilder(Sysctl instance) {
        this(instance, (Boolean)true);
    }

    public SysctlBuilder(Sysctl instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public SysctlBuilder(Validator validator) {
        this(new Sysctl(), (Boolean)true);
    }

    public SysctlBuilder(SysctlFluent<?> fluent, Sysctl instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SysctlBuilder(Sysctl instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Sysctl build() {
        Sysctl buildable = new Sysctl(this.fluent.getName(), this.fluent.getValue());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysctlBuilder that = (SysctlBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

