/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.TCPSocketAction;
import io.dekorate.deps.kubernetes.api.model.TCPSocketActionFluent;
import io.dekorate.deps.kubernetes.api.model.TCPSocketActionFluentImpl;

public class TCPSocketActionBuilder
extends TCPSocketActionFluentImpl<TCPSocketActionBuilder>
implements VisitableBuilder<TCPSocketAction, TCPSocketActionBuilder> {
    TCPSocketActionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TCPSocketActionBuilder() {
        this(true);
    }

    public TCPSocketActionBuilder(Boolean validationEnabled) {
        this(new TCPSocketAction(), validationEnabled);
    }

    public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TCPSocketAction(), validationEnabled);
    }

    public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent, TCPSocketAction instance) {
        this(fluent, instance, true);
    }

    public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent, TCPSocketAction instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withPort(instance.getPort());
        this.validationEnabled = validationEnabled;
    }

    public TCPSocketActionBuilder(TCPSocketAction instance) {
        this(instance, (Boolean)true);
    }

    public TCPSocketActionBuilder(TCPSocketAction instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withPort(instance.getPort());
        this.validationEnabled = validationEnabled;
    }

    public TCPSocketActionBuilder(Validator validator) {
        this(new TCPSocketAction(), (Boolean)true);
    }

    public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent, TCPSocketAction instance, Validator validator) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withPort(instance.getPort());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TCPSocketActionBuilder(TCPSocketAction instance, Validator validator) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withPort(instance.getPort());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public TCPSocketAction build() {
        TCPSocketAction buildable = new TCPSocketAction(this.fluent.getHost(), this.fluent.getPort());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TCPSocketActionBuilder that = (TCPSocketActionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

