/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Taint;
import io.dekorate.deps.kubernetes.api.model.TaintFluent;
import io.dekorate.deps.kubernetes.api.model.TaintFluentImpl;

public class TaintBuilder
extends TaintFluentImpl<TaintBuilder>
implements VisitableBuilder<Taint, TaintBuilder> {
    TaintFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaintBuilder() {
        this(true);
    }

    public TaintBuilder(Boolean validationEnabled) {
        this(new Taint(), validationEnabled);
    }

    public TaintBuilder(TaintFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TaintBuilder(TaintFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Taint(), validationEnabled);
    }

    public TaintBuilder(TaintFluent<?> fluent, Taint instance) {
        this(fluent, instance, true);
    }

    public TaintBuilder(TaintFluent<?> fluent, Taint instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEffect(instance.getEffect());
        fluent.withKey(instance.getKey());
        fluent.withTimeAdded(instance.getTimeAdded());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public TaintBuilder(Taint instance) {
        this(instance, (Boolean)true);
    }

    public TaintBuilder(Taint instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEffect(instance.getEffect());
        this.withKey(instance.getKey());
        this.withTimeAdded(instance.getTimeAdded());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public TaintBuilder(Validator validator) {
        this(new Taint(), (Boolean)true);
    }

    public TaintBuilder(TaintFluent<?> fluent, Taint instance, Validator validator) {
        this.fluent = fluent;
        fluent.withEffect(instance.getEffect());
        fluent.withKey(instance.getKey());
        fluent.withTimeAdded(instance.getTimeAdded());
        fluent.withValue(instance.getValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TaintBuilder(Taint instance, Validator validator) {
        this.fluent = this;
        this.withEffect(instance.getEffect());
        this.withKey(instance.getKey());
        this.withTimeAdded(instance.getTimeAdded());
        this.withValue(instance.getValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Taint build() {
        Taint buildable = new Taint(this.fluent.getEffect(), this.fluent.getKey(), this.fluent.getTimeAdded(), this.fluent.getValue());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaintBuilder that = (TaintBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

