/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Toleration;
import io.dekorate.deps.kubernetes.api.model.TolerationFluent;
import io.dekorate.deps.kubernetes.api.model.TolerationFluentImpl;

public class TolerationBuilder
extends TolerationFluentImpl<TolerationBuilder>
implements VisitableBuilder<Toleration, TolerationBuilder> {
    TolerationFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TolerationBuilder() {
        this(true);
    }

    public TolerationBuilder(Boolean validationEnabled) {
        this(new Toleration(), validationEnabled);
    }

    public TolerationBuilder(TolerationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Toleration(), validationEnabled);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Toleration instance) {
        this(fluent, instance, true);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Toleration instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEffect(instance.getEffect());
        fluent.withKey(instance.getKey());
        fluent.withOperator(instance.getOperator());
        fluent.withTolerationSeconds(instance.getTolerationSeconds());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public TolerationBuilder(Toleration instance) {
        this(instance, (Boolean)true);
    }

    public TolerationBuilder(Toleration instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEffect(instance.getEffect());
        this.withKey(instance.getKey());
        this.withOperator(instance.getOperator());
        this.withTolerationSeconds(instance.getTolerationSeconds());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public TolerationBuilder(Validator validator) {
        this(new Toleration(), (Boolean)true);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Toleration instance, Validator validator) {
        this.fluent = fluent;
        fluent.withEffect(instance.getEffect());
        fluent.withKey(instance.getKey());
        fluent.withOperator(instance.getOperator());
        fluent.withTolerationSeconds(instance.getTolerationSeconds());
        fluent.withValue(instance.getValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TolerationBuilder(Toleration instance, Validator validator) {
        this.fluent = this;
        this.withEffect(instance.getEffect());
        this.withKey(instance.getKey());
        this.withOperator(instance.getOperator());
        this.withTolerationSeconds(instance.getTolerationSeconds());
        this.withValue(instance.getValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Toleration build() {
        Toleration buildable = new Toleration(this.fluent.getEffect(), this.fluent.getKey(), this.fluent.getOperator(), this.fluent.getTolerationSeconds(), this.fluent.getValue());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TolerationBuilder that = (TolerationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

